package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import nexcore.sprout.foundry.resourcebundle.message.DBReloadableResourceBundleMessageSource;
import nexcore.sprout.foundry.resourcebundle.message.ReloadableResourceBundleMessageSource;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.MessageSourceProperties.MessageDataSourceProperties;

@Configuration	
@EnableConfigurationProperties(MessageDataSourceProperties.class)
@AutoConfigureBefore(MessageSourceAutoConfiguration.class)
@AutoConfigureAfter(SproutDataSourceAutoConfiguration.class)
@ConditionalOnMissingBean(ReloadableResourceBundleMessageSource.class)
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_MESSAGE_DATASOURCE, name = "enabled", havingValue = "true")
public class MessageDataSourceAutoConfiguration implements ApplicationContextAware{
	
	private static final Log logger = LogFactory.getLog(MessageDataSourceAutoConfiguration.class);
	
	@Autowired
	private ApplicationContext applicationContext;

	@Autowired
	private MessageDataSourceProperties messageDataSourceProperties;
	
	@Bean
	@ConditionalOnBean(name=SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME)
	public DBReloadableResourceBundleMessageSource messageSource(){
		logger.info("===== MessageSource DataSource Enabled: True");
		
		DBReloadableResourceBundleMessageSource messageDatasource = new DBReloadableResourceBundleMessageSource();
		messageDatasource.setDataSource((DataSource) this.applicationContext.getBean(SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME));
		
		if(messageDataSourceProperties.isFallbackToSystemLocale())
			messageDatasource.setFallbackToSystemLocale(messageDataSourceProperties.isFallbackToSystemLocale());
		if(messageDataSourceProperties.getCacheSeconds() != 0)
			messageDatasource.setCacheSeconds(messageDataSourceProperties.getCacheSeconds());
		if(messageDataSourceProperties.getQueryCode() != null)
			messageDatasource.setQueryCode(messageDataSourceProperties.getQueryCode());
		if(messageDataSourceProperties.getName() != null)
			messageDatasource.setBeanName(messageDataSourceProperties.getName());
		
		logger.info("====== Creating MessageSourceForDB.");
		return messageDatasource;
	}
	
	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}

}
