package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_CODE_RESOURCE, ignoreUnknownFields = false)
public class CodeSourceProperties {

	/*
	 * ReloadableResourceBundleCodeSource
	 */
	/** CodeSource order*/
	private int order;
	/** CodeSource name*/
	private String name;
	/** CodeSource group*/
	private String group;
	/** ResourceBundle 캐시를 로드하기위한 시간 default : 5 */
	private int cacheSeconds = 5;
    /** System locale 추가 여부 default : false */
	private boolean fallbackToSystemLocale;
    /** CodeSource 파일 경로 */
	private String basename;
    /** defaultEncoding */
	private String defaultEncoding;
    /** custom Basefile PostFix Name default : _ko_KR */
	private String defaultFilePostFix;
	/** custom Basefile 사용 여부 true 일 경우 fallbackToSystemLocale이 true 이더라도 fallbackfile을 추가 하지 않는 다. */
	private boolean useCustomDefaultFile;
	
	private CodeDataSourceProperties codeDataSourceProperties = new CodeDataSourceProperties();
	
	public int getOrder() {
		return order;
	}

	public void setOrder(int order) {
		this.order = order;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public int getCacheSeconds() {
		return cacheSeconds;
	}

	public void setCacheSeconds(int cacheSeconds) {
		this.cacheSeconds = cacheSeconds;
	}

	public boolean isFallbackToSystemLocale() {
		return fallbackToSystemLocale;
	}

	public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
		this.fallbackToSystemLocale = fallbackToSystemLocale;
	}

	public String getBasename() {
		return basename;
	}

	public void setBasename(String basename) {
		this.basename = basename;
	}

	public String getDefaultEncoding() {
		return defaultEncoding;
	}

	public void setDefaultEncoding(String defaultEncoding) {
		this.defaultEncoding = defaultEncoding;
	}

	public String getDefaultFilePostFix() {
		return defaultFilePostFix;
	}

	public void setDefaultFilePostFix(String defaultFilePostFix) {
		this.defaultFilePostFix = defaultFilePostFix;
	}

	public boolean isUseCustomDefaultFile() {
		return useCustomDefaultFile;
	}

	public void setUseCustomDefaultFile(boolean useCustomDefaultFile) {
		this.useCustomDefaultFile = useCustomDefaultFile;
	}
	
	public CodeDataSourceProperties getCodeDataSourceProperties() {
		return codeDataSourceProperties;
	}

	public void setCodeDataSourceProperties(CodeDataSourceProperties codeDataSourceProperties) {
		this.codeDataSourceProperties = codeDataSourceProperties;
	}

	/*
	 * DBReloadableResourceBundleMessageSource
	 */
	@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_CODE_DATASOURCE, ignoreUnknownFields = false)
	public static class CodeDataSourceProperties {
		/** CodeDataSource 사용여부 default : false*/
		private boolean enabled = false;
		/** CodeDataSource order*/
		private int order;
		/** CodeDataSource name*/
		private String name;
		/** CodeDataSource group*/
		private String group;
		/** ResourceBundle 캐시를 로드하기위한 시간 default : 5 */
		private int cacheSeconds = 5;
	    /** System locale 추가 여부 default : false */
		private boolean fallbackToSystemLocale;
		
		private String queryCode;

		public boolean isEnabled() {
			return enabled;
		}

		public void setEnabled(boolean enabled) {
			this.enabled = enabled;
		}

		public int getOrder() {
			return order;
		}

		public void setOrder(int order) {
			this.order = order;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getGroup() {
			return group;
		}

		public void setGroup(String group) {
			this.group = group;
		}

		public int getCacheSeconds() {
			return cacheSeconds;
		}

		public void setCacheSeconds(int cacheSeconds) {
			this.cacheSeconds = cacheSeconds;
		}

		public boolean isFallbackToSystemLocale() {
			return fallbackToSystemLocale;
		}

		public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
			this.fallbackToSystemLocale = fallbackToSystemLocale;
		}

		public String getQueryCode() {
			return queryCode;
		}

		public void setQueryCode(String queryCode) {
			this.queryCode = queryCode;
		}
		
	}
	
}