package nexcore.sprout.spring.boot.autoconfigure.reload;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.jmx.export.MBeanExporter;

import nexcore.sprout.foundry.reload.ReloadMulticaster;
import nexcore.sprout.foundry.utils.ProfileUtil;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;
import redis.clients.jedis.Jedis;

@Configuration
@ConditionalOnClass({ MBeanExporter.class })
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_RELOAD_MULTICASTER, name = "enabled", havingValue="true")
public class ReloadAutoConfiguration {

	private static final Log logger = LogFactory.getLog(ReloadAutoConfiguration.class);
	
	@Bean
	public ReloadMulticaster reloadMulticaster(){
		ReloadMulticaster reloadMulticaster = new ReloadMulticaster();
		logger.info("====== Creating Bean: " + reloadMulticaster.getClass().toString());
		return reloadMulticaster;
	}
	
	@Configuration
	@ConditionalOnClass({ JedisConnection.class, RedisOperations.class, Jedis.class })
	@Profile(value=SproutAutoConfigConst.ACTIVE_PROFILE_NAME_DEV)
	@AutoConfigureAfter(ReloadMulticaster.class)
	protected static class ReloadForRedis {
		private static final Log logger = LogFactory.getLog(ReloadForRedis.class);
		
		@Autowired
		private Environment env;
		
		@Bean
		public RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory,
				MessageListenerAdapter listenerAdapter) {

			RedisMessageListenerContainer container = new RedisMessageListenerContainer();
			container.setConnectionFactory(connectionFactory);
			container.addMessageListener(listenerAdapter, topic());

			logger.info("====== Creating Bean: " + container.getClass().toString());
			return container;
		}

		@Bean
		public MessageListenerAdapter listenerAdapter(ReloadMulticaster receiver) {
			MessageListenerAdapter listenerAdapter = new MessageListenerAdapter();
			listenerAdapter.setDelegate(receiver);
			listenerAdapter.setDefaultListenerMethod(SproutAutoConfigConst.REDIS_RELOADMULTICAST_METHOD_NAME);
			logger.info("====== Creating Bean: " + listenerAdapter.getClass().toString());
			return listenerAdapter;
		}
		
		@Bean
		public ChannelTopic topic() {        
			String activeProfile = ProfileUtil.getActiveProfile(env,SproutAutoConfigConst.ACTIVE_PROFILE_NAME_LIST);
			String topic = SproutAutoConfigConst.REDIS_RELOADMULTICAST_TOPIC +"."+activeProfile;

			logger.info("====== Redis Topic : " + topic);
		    return new ChannelTopic(topic);
		}
	}
}
