package nexcore.sprout.spring.boot.autoconfigure.redis;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.data.redis.config.ConfigureRedisAction;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;

import redis.clients.jedis.Jedis;

@Configuration
@EnableRedisHttpSession
@ConditionalOnClass({ JedisConnection.class, RedisOperations.class, Jedis.class })
public class RedisAutoConfiguration {
	
	private static final Log logger = LogFactory.getLog(RedisAutoConfiguration.class);
	
	// secured 레디스 환경에서 설정 명령어는 disabled. 
	// 스프링 세션이 레디스 키스페이스 이벤트를 설정하지 못하므로, 
	// 자동설정을 disable하기 위해 빈으로 ConfigureRedisAction.NO_OP를 추가.
	@Bean
	@ConditionalOnMissingBean
	public static ConfigureRedisAction configureRedisAction() {
		logger.info("====== Redis Action: " + ConfigureRedisAction.NO_OP);
		return ConfigureRedisAction.NO_OP;
	}

}
