package nexcore.sprout.spring.boot.autoconfigure.log.monitor;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_LOG_MONITOR)
public class LogMonitorProperties {
	
	/** 기본 로그 작성 주기 기본값은 : 5*/
	private int writeLogInterval = 5;
	/** 로그 구분 서비스 이름 기본값: default */
	private String serviceName="";
	/** Logstash Access 로거 이름  기본값: logstash.log */
	private String accessLoggerName = "logstash.log";
	/** Logstash 주기적 로거 이름 기본값: logstash.log */
	private String periodLoggerName = "logstash.log";
	/** 유입경로 정보 추가 여부 기본값: true */
	private boolean useInflowsInfo = true;
	
	public int getWriteLogInterval() {
		return writeLogInterval;
	}
	public void setWriteLogInterval(int writeLogInterval) {
		this.writeLogInterval = writeLogInterval;
	}
	public String getServiceName() {
		return serviceName;
	}
	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}
	public String getAccessLoggerName() {
		return accessLoggerName;
	}
	public void setAccessLoggerName(String accessLoggerName) {
		this.accessLoggerName = accessLoggerName;
	}
	public String getPeriodLoggerName() {
		return periodLoggerName;
	}
	public void setPeriodLoggerName(String periodLoggerName) {
		this.periodLoggerName = periodLoggerName;
	}
	public boolean isUseInflowsInfo() {
		return useInflowsInfo;
	}
	public void setUseInflowsInfo(boolean useInflowsInfo) {
		this.useInflowsInfo = useInflowsInfo;
	}
}
