package nexcore.sprout.spring.boot.autoconfigure.log;

import javax.sql.DataSource;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

import nexcore.sprout.foundry.log.accesslog.old.AccessLogDbWriterForOldBcm;
import nexcore.sprout.foundry.log.errorlog.ErrorLogDbWriter;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.log.AccessLogProperties.ErrorLogProperties;

@Configuration
@ConditionalOnBean(name={SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME,SproutAutoConfigConst.TRANSACTION_MANAGER_FOR_SPROUT_NAME})
@EnableConfigurationProperties({AccessLogProperties.class, ErrorLogProperties.class})
@AutoConfigureAfter({SproutDataSourceAutoConfiguration.class})
@AutoConfigureBefore({AccessLogManagerAutoConfiguration.class})
public class AccessLogWriterConfiguration implements ApplicationContextAware {

	@Autowired
	private ApplicationContext applicationContext;
	
	@Autowired
	private AccessLogProperties accessLogProperties;
	
	@Autowired
	private ErrorLogProperties errorLogProperties;
	
	@Bean
	@ConditionalOnBean(name={SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME,SproutAutoConfigConst.TRANSACTION_MANAGER_FOR_SPROUT_NAME})
	@ConditionalOnMissingClass
	@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_ACCESS_LOG, name="enabled", havingValue="true", matchIfMissing=true)
	public AccessLogDbWriterForOldBcm accessLogDbWriter(){
		AccessLogDbWriterForOldBcm accessLogDbWriter = new AccessLogDbWriterForOldBcm();
		accessLogDbWriter.setDataSource(this.applicationContext.getBean(SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME, DataSource.class));
		accessLogDbWriter.setTransactionManager(this.applicationContext.getBean(SproutAutoConfigConst.TRANSACTION_MANAGER_FOR_SPROUT_NAME, PlatformTransactionManager.class));
		
		if(accessLogProperties.getInsertQuery() != null)
			accessLogDbWriter.setInsertQuery(accessLogProperties.getInsertQuery());
		if(accessLogProperties.isWriteErrorLog())
			accessLogDbWriter.setWriteErrorLog(accessLogProperties.isWriteErrorLog());
		
		return accessLogDbWriter;
	}
	
	@Bean
	@ConditionalOnMissingClass
	@ConditionalOnProperty(prefix=SproutAutoConfigConst.PREFIX_SPROUT_ERROR_LOG,name="enabled", havingValue="true", matchIfMissing=true)
	@ConditionalOnBean(name={SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME,SproutAutoConfigConst.TRANSACTION_MANAGER_FOR_SPROUT_NAME})
	public ErrorLogDbWriter errorLogDbWriter(){
		ErrorLogDbWriter errorLogDbWriter = new ErrorLogDbWriter();
		errorLogDbWriter.setDataSource(this.applicationContext.getBean(SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME, DataSource.class));
		errorLogDbWriter.setTransactionManager(this.applicationContext.getBean(SproutAutoConfigConst.TRANSACTION_MANAGER_FOR_SPROUT_NAME, PlatformTransactionManager.class));
		
		if(errorLogProperties.getInsertQuery() != null)
			errorLogDbWriter.setInsertQuery(errorLogProperties.getInsertQuery());
		
		return errorLogDbWriter;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}
	
}
