package nexcore.sprout.spring.boot.autoconfigure.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.LiteDeviceResolver;

import nexcore.sprout.foundry.log.accesslog.AccessLogManager;
import nexcore.sprout.foundry.log.accesslog.IAccessLogDataExtractor;
import nexcore.sprout.foundry.log.accesslog.IAccessLogWriter;
import nexcore.sprout.log.monitor.writer.logstash.LogstashAccessLogWriter;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.log.monitor.LogMonitorProperties;

@Configuration
@EnableConfigurationProperties(LogMonitorProperties.class)
@AutoConfigureAfter({SproutDataSourceAutoConfiguration.class})
public class AccessLogManagerAutoConfiguration  {
	
	@Autowired
	private ConfigurableApplicationContext applicationContext;
	
	@Qualifier(SproutAutoConfigConst.DEFAULT_LOG_DATA_EXTRACTOR)
	
	@Autowired
	private IAccessLogDataExtractor accessLogDataExtractor;
	
	@Autowired
	private LogMonitorProperties logMonitorProperties;
	
	@Bean
	@ConditionalOnMissingBean(AccessLogManager.class)
	@ConditionalOnBean(IAccessLogWriter.class)
	public AccessLogManager accessLogManager() {
		AccessLogManager accessLogManager = new AccessLogManager();
		ArrayList<IAccessLogWriter> AccessLogList = new ArrayList<IAccessLogWriter>();
		AccessLogList.addAll(findIAccessLogWriter());
		accessLogManager.setAsscessLogWriters(AccessLogList);
		accessLogManager.setAccessLogDataExtractor(accessLogDataExtractor);
		
		return accessLogManager;
	}
	
	@Bean
	@ConditionalOnProperty(prefix=SproutAutoConfigConst.PREFIX_SPROUT_LOG_MONITOR, name="enabled", havingValue="true")
	@ConditionalOnMissingBean(name=SproutAutoConfigConst.LOGSTASH_ACCESS_LOG_WRITER)
	public LogstashAccessLogWriter logstashAccessLogWriter() {
		LogstashAccessLogWriter logstashAccessLogWriter = new LogstashAccessLogWriter();
		logstashAccessLogWriter.setUseYN(true);
		logstashAccessLogWriter.setDeviceResolver(this.applicationContext.getBean(DeviceResolver.class));
		
		if(logMonitorProperties.getServiceName() != null)
			logstashAccessLogWriter.setServiceGroupName(logMonitorProperties.getServiceName());
		if(logMonitorProperties.getAccessLoggerName() != null)
			logstashAccessLogWriter.setLogstashLoggerName(logMonitorProperties.getAccessLoggerName());
		if(logMonitorProperties.isUseInflowsInfo())
			logstashAccessLogWriter.setUseInflowsInfo(logMonitorProperties.isUseInflowsInfo());
		return logstashAccessLogWriter;
	}

	@Bean
	@ConditionalOnProperty(prefix=SproutAutoConfigConst.PREFIX_SPROUT_LOG_MONITOR, name="enabled", havingValue="true")
	@ConditionalOnMissingBean(DeviceResolver.class)
	public DeviceResolver deviceResolver() {
		return new LiteDeviceResolver();
	}
	
	public List<IAccessLogWriter> findIAccessLogWriter() {
		List<IAccessLogWriter> iAccessLogWriterList = new ArrayList<IAccessLogWriter>();

		if (this.applicationContext == null) {
			return Collections.emptyList();
		}
		
		for (IAccessLogWriter iAccessLogWriter : getBeans(IAccessLogWriter.class)) {
			iAccessLogWriterList.add(iAccessLogWriter);
		}
		return iAccessLogWriterList;
	}
	
	private <T> Collection<T> getBeans(Class<T> type) {
		return BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext.getBeanFactory(), type).values();
	}
	
}
