package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_DATASOURCE_SQLLOG)
public class SproutSqlLogProperties {

	/** 
	 * Sql Log 사용여부.
	 * Default Value: true 
	 */
	private boolean use=true;
	
	/** 
	 * Sql Log에 출력될 Prefix. 
	 * Default Value: "SQL :" 
	 */
	private String sqlLogPrefix="SQL :";
	
	/** 
	 * Sql Log의 SQL을 호출한 Class를 출력.
	 * Default Value: false 
	 */
	private boolean showCallClass=false;
	
	private int lineLength=120;
	 
	public boolean isUse() {
		return use;
	}
	public void setUse(boolean use) {
		this.use = use;
	}
	public String getSqlLogPrefix() {
		return sqlLogPrefix;
	}
	public void setSqlLogPrefix(String sqlLogPrefix) {
		this.sqlLogPrefix = sqlLogPrefix;
	}
	public boolean isShowCallClass() {
		return showCallClass;
	}
	public void setShowCallClass(boolean showCallClass) {
		this.showCallClass = showCallClass;
	}
	public int getLineLength() {
		return lineLength;
	}
	public void setLineLength(int lineLength) {
		this.lineLength = lineLength;
	}
	
}
