package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;
/**
 * 
 * 
 * */
@Configuration
@ConditionalOnClass({ SqlSessionFactory.class, SqlSessionFactoryBean.class,org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration.class })
@EnableConfigurationProperties(MybatisProperties.class)
@AutoConfigureBefore( {org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration.class})
@ConditionalOnProperty(prefix=SproutAutoConfigConst.PREFIX_SPROUT_DATASOURCE,name="useConfig",matchIfMissing=true)
public class SproutMybatisAutoConfiguration extends org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration {  

	private static Log logger = LogFactory.getLog(SproutMybatisAutoConfiguration.class);
	
	private static final String mybatisConfigPath = "classpath:META-INF/persistence/mybatis/mybatis-config.xml";
	
	@Autowired
	private MybatisProperties properties;

	@Autowired
	private ResourceLoader resourceLoader = new DefaultResourceLoader();

	@Bean
	@ConditionalOnMissingBean
	public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
		logger.debug("**************** Start create sqlSessionFactory");
		SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
		factory.setDataSource(dataSource);
		if (StringUtils.hasText(this.properties.getConfig())) {
			factory.setConfigLocation(this.resourceLoader.getResource(this.properties.getConfig()));
		} else {
			logger.info("**************** mybatis.resource is null");
			if (ResourceUtils.getFile(mybatisConfigPath) != null) {
				logger.info("**************** MyBatis Configfile exist in " + mybatisConfigPath);
				Resource resource = new PathMatchingResourcePatternResolver().getResource(mybatisConfigPath);
				factory.setConfigLocation(resource);
			} else {
				factory.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
				factory.setTypeHandlersPackage(this.properties.getTypeHandlersPackage());
				factory.setMapperLocations(this.properties.getMapperLocations());
			}
		}
		return factory.getObject();
	}
	
	@Bean(destroyMethod="clearCache")
	@ConditionalOnMissingBean
	public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
		return new SqlSessionTemplate(sqlSessionFactory,
				this.properties.getExecutorType());
	}
	
}
