package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

/**
 * Base class for configuration of a SproutDataSourceAutoConfiguration
 *
 */
@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_DATASOURCE)
public class SproutDataSourceProperties  {
	
	/**
	 * Use sprout DatasourceAutoconfig.
	 * Default Value: true
	 */
	private boolean useConfig=true;
	/** 
	 * defaultDataSourceNameForSprout
	 * Default Value: dataSourceForSprout
	 */
	private String defaultDataSourceNameForSprout="dataSourceForSprout";
	
	public boolean isUseConfig() {
		return useConfig;
	}

	public void setUseConfig(boolean useConfig) {
		this.useConfig = useConfig;
	}

	public String getDefaultDataSourceNameForSprout() {
		return defaultDataSourceNameForSprout;
	}

	public void setDefaultDataSourceNameForSprout(String defaultDataSourceNameForSprout) {
		this.defaultDataSourceNameForSprout = defaultDataSourceNameForSprout;
	}
	
}
