package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;
import org.springframework.context.annotation.Profile;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

import nexcore.sprout.foundry.exception.hanlder.ExceptionHandler;
import nexcore.sprout.foundry.exception.hanlder.web.ExceptionResolverComposite;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@Profile(SproutAutoConfigConst.ACTIVE_PROFILE_NAME_EXCEPTION_RESOLVER_COMPOSITE)
@ConditionalOnBean({ExceptionHandler.class})
@EnableConfigurationProperties(SproutExceptionProperties.class)
@AutoConfigureBefore(SproutExceptionResolverAutoConfiguration.class)
@Description("for Integration with other HandlerExceptionResolver. ex) Default ExceptionResolver, Customized ExceptionResolver")
public class SproutExceptionResolverCompositeAutoConfiguration extends WebMvcConfigurerAdapter implements ApplicationContextAware {
	
	private static final Log logger = LogFactory.getLog(SproutExceptionResolverCompositeAutoConfiguration.class);
	
	private ConfigurableApplicationContext applicationContext;
	
	@Autowired
	private SproutExceptionProperties exceptionProperties;
	
	@Bean
    public SimpleMappingExceptionResolver simpleMappingExceptionResolver() {
        SimpleMappingExceptionResolver simpleMappingExceptionResolver = new SimpleMappingExceptionResolver();
        simpleMappingExceptionResolver.setDefaultErrorView(exceptionProperties.getDefaultViewName());
        logger.info("====== Creating Bean: " + simpleMappingExceptionResolver.getClass().toString());
		logger.info("====== DefaultViewName for SimpleMappingExceptionResolver: " + exceptionProperties.getDefaultViewName());
        return simpleMappingExceptionResolver;
    }
	
	@Bean
	@ConditionalOnMissingBean
	public ExceptionResolverComposite exceptionResolver() throws IOException {
		ExceptionResolverComposite exceptionResolver = new ExceptionResolverComposite();
		exceptionResolver.setExceptionHandler(this.applicationContext.getBean(ExceptionHandler.class));
		logger.info("====== Creating Bean: " + exceptionResolver.getClass().toString());
		logger.info("====== ExceptionHandler for ExceptionResolver: " + this.applicationContext.getBean(ExceptionHandler.class).toString());
		return exceptionResolver;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		if (applicationContext instanceof ConfigurableApplicationContext) {
			this.applicationContext = (ConfigurableApplicationContext) applicationContext;
		}
	}

}