package nexcore.sprout.spring.boot.autoconfigure.commons;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;

import nexcore.sprout.foundry.commons.IUserIdFinder;
import nexcore.sprout.foundry.commons.impl.DefaultUserIdFinder;

@Configuration
@ConditionalOnClass({ AuthenticationManager.class, GlobalAuthenticationConfigurerAdapter.class })
@AutoConfigureBefore(UserIdFinderAutoConfiguration.class)
public class UserIdFinderForSecurityAutoConfiguration {
	
	private static final Log logger = LogFactory.getLog(UserIdFinderForSecurityAutoConfiguration.class);

	@Bean
	@ConditionalOnMissingBean(IUserIdFinder.class)
	public DefaultUserIdFinder userIdFinder() {
		DefaultUserIdFinder defaultUserIdFinder = new DefaultUserIdFinder();
		logger.info("====== Creating UserIdFinder Bean for Security: " + defaultUserIdFinder.getClass().toString());
		return defaultUserIdFinder;
	}

}
