/*
 * Decompiled with CFR 0.152.
 */
package network.quant.event;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import lombok.NonNull;
import network.quant.compoent.ApplicationFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMovingEvent
extends MouseAdapter
implements MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(ApplicationMovingEvent.class);
    private static ApplicationMovingEvent I;
    @NonNull
    private JFrame frame;
    private Point screenLocation;
    private Point mouseLocation;

    @Override
    public void mousePressed(MouseEvent e) {
        this.screenLocation = this.frame.getLocationOnScreen();
        this.mouseLocation = e.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point point = e.getPoint();
        point.x -= this.mouseLocation.x;
        point.y -= this.mouseLocation.y;
        this.screenLocation.x += point.x;
        this.screenLocation.y += point.y;
        this.frame.setLocation(this.screenLocation);
    }

    public static ApplicationFrame adapter(ApplicationFrame frame) {
        if (null == I) {
            I = new ApplicationMovingEvent(frame);
            frame.addMouseListener(I);
            frame.addMouseMotionListener(I);
        }
        return frame;
    }

    public ApplicationMovingEvent(@NonNull JFrame frame) {
        if (frame == null) {
            throw new NullPointerException("frame is marked @NonNull but is null");
        }
        this.frame = frame;
    }
}

