/*
 * Decompiled with CFR 0.152.
 */
package network.quant.compoent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JTextField;
import network.quant.compoent.BaseComponent;
import network.quant.compoent.Button;
import network.quant.utils.UITools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletComponent
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(WalletComponent.class);
    private static final Color TEXT = new Color(38, 31, 99);
    private Image coin;
    private JLabel secretKeyLabel = new JLabel("Secret Key");
    private JLabel publicAddressLabel = new JLabel("Address");
    public JTextField secretKey = new JTextField();
    public JTextField publicAddress = new JTextField();
    private Button generateButton = new Button("Generate", Button.TYPE.OK);
    private Button receiveButton = new Button("Receive", Button.TYPE.NORMAL);
    private WalletHandler walletHandler;

    public WalletComponent(Dimension dimension, TYPE type, WalletHandler walletHandler) {
        super(dimension);
        this.walletHandler = walletHandler;
        int componentIndex = 0;
        this.coin = Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource(String.format("%s.png", type.name()))).getScaledInstance(32, 32, 4);
        this.secretKeyLabel.setSize(90, 32);
        this.secretKeyLabel.setLocation(100, 10);
        this.secretKeyLabel.setFont(UITools.getFont(1, 16.0f));
        this.secretKeyLabel.setForeground(TEXT);
        this.secretKeyLabel.setHorizontalAlignment(4);
        this.add((Component)this.secretKeyLabel, componentIndex++);
        this.secretKey.setSize(dimension.width - 420, 32);
        this.secretKey.setLocation(200, 10);
        this.secretKey.setFont(UITools.getFont(0, 16.0f));
        this.secretKey.setForeground(TEXT);
        this.add((Component)this.secretKey, componentIndex++);
        this.publicAddressLabel.setSize(90, 32);
        this.publicAddressLabel.setLocation(100, 50);
        this.publicAddressLabel.setFont(UITools.getFont(1, 16.0f));
        this.publicAddressLabel.setForeground(TEXT);
        this.publicAddressLabel.setHorizontalAlignment(4);
        this.add((Component)this.publicAddressLabel, componentIndex++);
        this.publicAddress.setSize(dimension.width - 420, 32);
        this.publicAddress.setLocation(200, 50);
        this.publicAddress.setFont(UITools.getFont(0, 16.0f));
        this.publicAddress.setForeground(TEXT);
        this.add((Component)this.publicAddress, componentIndex++);
        this.generateButton.setSize(150, 50);
        this.generateButton.setLocation(dimension.width - 150, 0);
        this.generateButton.addActionListener(event -> this.walletHandler.generate(type));
        this.add((Component)this.generateButton, componentIndex++);
        this.receiveButton.setSize(150, 50);
        this.receiveButton.setLocation(dimension.width - 150, dimension.height - 50);
        this.receiveButton.addActionListener(event -> this.walletHandler.receive(type));
        this.add((Component)this.receiveButton, componentIndex++);
    }

    @Override
    protected void paintComponent(Graphics2D g2D) {
        super.paintComponent(g2D);
        g2D.setColor(Color.WHITE);
        g2D.fillRoundRect(0, 0, this.getSize().width, this.getSize().height, 8, 8);
        g2D.drawImage(this.coin, 10, 10, this);
    }

    public static enum TYPE {
        bitcoin,
        ethereum,
        ripple;

    }

    public static interface WalletHandler {
        public void generate(TYPE var1);

        public void receive(TYPE var1);
    }
}

