/*
 * Decompiled with CFR 0.152.
 */
package network.quant.compoent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import network.quant.api.DLT;
import network.quant.api.OverledgerTransaction;
import network.quant.compoent.BaseComponent;
import network.quant.compoent.Button;
import network.quant.essential.dto.DltTransactionResponse;
import network.quant.essential.dto.OverledgerTransactionResponse;
import network.quant.mvp.presenter.ContentPresenter;
import network.quant.util.Page;
import network.quant.utils.UITools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderPanel
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(OrderPanel.class);
    private static final Color TEXT = new Color(38, 31, 99);
    private static Map<String, Image> DLT_ICONS = new HashMap<String, Image>();
    private ContentPresenter contentPresenter;
    private JList<OverledgerTransactionResponse> transactionList = new JList();
    private JScrollPane transactionPane;
    private DefaultListModel<OverledgerTransactionResponse> transactionListModel = new DefaultListModel();
    private Page page;
    private JLabel pageLabel = new JLabel();
    private Button nextButton = new Button(">", Button.TYPE.OK);
    private Button previousButton = new Button("<", Button.TYPE.OK);
    private Button okButton = new Button("OK", Button.TYPE.OK);

    public OrderPanel(Dimension dimension, ContentPresenter contentPresenter) {
        super(dimension);
        this.contentPresenter = contentPresenter;
        int componentIndex = 0;
        JLabel label = new JLabel("Order");
        label.setSize(dimension.width - 20, 64);
        label.setLocation(10, 10);
        label.setFont(UITools.getFont(0, 48.0f));
        label.setForeground(TEXT);
        this.add((Component)label, componentIndex++);
        this.pageLabel.setSize(200, 64);
        this.pageLabel.setLocation(dimension.width - 260, 10);
        this.pageLabel.setFont(UITools.getFont(0, 16.0f));
        this.pageLabel.setForeground(TEXT);
        this.pageLabel.setHorizontalAlignment(0);
        this.pageLabel.setVerticalAlignment(0);
        this.add((Component)this.pageLabel, componentIndex++);
        this.nextButton.setSize(48, 48);
        this.nextButton.setLocation(dimension.width - 60, 10);
        this.nextButton.addActionListener(event -> {
            this.page.setPageNumber(this.page.getPageNumber() + 1);
            this.contentPresenter.onLoadOrders(this.page);
        });
        this.add((Component)this.nextButton, componentIndex++);
        this.previousButton.setSize(48, 48);
        this.previousButton.setLocation(dimension.width - 320, 10);
        this.previousButton.addActionListener(event -> {
            this.page.setPageNumber(this.page.getPageNumber() - 1);
            this.contentPresenter.onLoadOrders(this.page);
        });
        this.add((Component)this.previousButton, componentIndex++);
        this.transactionList.setOpaque(false);
        this.transactionList.setModel(this.transactionListModel);
        this.transactionList.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> new CellComponent(list, (OverledgerTransactionResponse)value, index, isSelected));
        this.transactionList.setSelectionMode(0);
        this.transactionPane = new JScrollPane(this.transactionList);
        this.transactionPane.setOpaque(false);
        this.transactionPane.getViewport().setOpaque(false);
        this.transactionPane.setBorder(BorderFactory.createEmptyBorder());
        this.transactionPane.setLocation(10, 70);
        this.transactionPane.setSize(new Dimension(dimension.width - 20, dimension.height - 150));
        this.transactionPane.setHorizontalScrollBarPolicy(31);
        this.transactionPane.setVerticalScrollBarPolicy(20);
        this.add((Component)this.transactionPane, componentIndex++);
        this.okButton.setSize(150, 48);
        this.okButton.setLocation(dimension.width - 150, dimension.height - 50);
        this.okButton.addActionListener(event -> this.contentPresenter.onGotoMain());
        this.add((Component)this.okButton, componentIndex++);
    }

    public void loadArray(OverledgerTransactionResponse[] writeOverledgerTransactionResponses) {
        Stream.of(writeOverledgerTransactionResponses).forEach(overledgerTransactionResponse -> this.transactionListModel.addElement((OverledgerTransactionResponse)overledgerTransactionResponse));
    }

    public void loadList(List<OverledgerTransaction> writeOverledgerTransactionResponses, Page page) {
        this.page = page;
        this.pageLabel.setText(String.format("Page: %d of %d", page.getPageNumber() + 1, page.getTotalPages()));
        this.nextButton.setVisible(!page.isLast());
        this.previousButton.setVisible(!page.isFirst());
        this.transactionListModel.clear();
        writeOverledgerTransactionResponses.stream().forEach(overledgerTransactionResponse -> this.transactionListModel.addElement((OverledgerTransactionResponse)overledgerTransactionResponse));
    }

    static {
        DLT_ICONS.put(DLT.bitcoin.name(), Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource(String.format("%s.png", DLT.bitcoin.name()))).getScaledInstance(32, 32, 4));
        DLT_ICONS.put(DLT.ethereum.name(), Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource(String.format("%s.png", DLT.ethereum.name()))).getScaledInstance(32, 32, 4));
        DLT_ICONS.put(DLT.ripple.name(), Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource(String.format("%s.png", DLT.ripple.name()))).getScaledInstance(32, 32, 4));
    }

    private class CellComponent
    extends BaseComponent {
        private OverledgerTransactionResponse value;
        private int index;
        private boolean isSelected;
        private JLabel label;

        public CellComponent(JList<? extends OverledgerTransactionResponse> list, OverledgerTransactionResponse value, int index, boolean isSelected) {
            super(new Dimension(list.getSize().width - 20, 100));
            this.value = value;
            this.index = index;
            this.isSelected = isSelected;
            this.label = new JLabel();
        }

        @Override
        protected void paintComponent(Graphics2D g2D) {
            g2D.setColor(Color.WHITE);
            g2D.fillRoundRect(10, 5, this.getSize().width - 20, 90, 8, 8);
            this.label.setForeground(TEXT);
            this.label.setFont(UITools.getFont(0, 24.0f));
            this.label.setText(this.value.getOverledgerTransactionId().toString());
            this.label.setSize(this.getSize().width - 40, 32);
            this.label.paint(g2D.create(20, 10, this.getSize().width - 40, 32));
            this.label.setFont(UITools.getFont(0, 16.0f));
            this.label.setText(this.value.getTimestamp());
            this.label.setHorizontalAlignment(4);
            this.label.setSize(this.getSize().width - 40, 32);
            this.label.paint(g2D.create(20, 10, this.getSize().width - 40, 32));
            this.label.setFont(UITools.getFont(0, 16.0f));
            this.label.setHorizontalAlignment(2);
            this.label.setSize(300, 32);
            for (int i = 0; i < this.value.getDltData().size(); ++i) {
                DltTransactionResponse dltTransactionResponse = (DltTransactionResponse)this.value.getDltData().get(i);
                this.label.setText(dltTransactionResponse.getStatus().getStatus().name());
                this.label.paint(g2D.create(i * 300 + 60, 50, 200, 32));
                g2D.drawImage(DLT_ICONS.get(dltTransactionResponse.getDlt()), i * 300 + 20, 50, this);
            }
        }
    }
}

