/*
 * Decompiled with CFR 0.152.
 */
package network.quant.compoent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import network.quant.compoent.BaseComponent;
import network.quant.mvp.presenter.HeaderPresenter;
import network.quant.mvp.view.HeaderView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderPanel
extends BaseComponent
implements HeaderView {
    private static final Logger log = LoggerFactory.getLogger(HeaderPanel.class);
    private Image logo;
    private Image subLogo;
    private Image closeImage;
    private Image walletImage;
    private Image settingsImage;
    private Image orderImage;
    private JLabel closeLabel;
    private JLabel walletLabel;
    private JLabel settingsLabel;
    private JLabel orderLabel;
    private HeaderPresenter headerPresenter;

    private HeaderPanel() {
        super(new Dimension(1024, 82));
        try {
            this.logo = Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("Quant-Logo.png"));
            this.subLogo = Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("Overledger-Logo.png"));
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        this.initialComponents();
    }

    private void initialComponents() {
        int componentIndex = 0;
        this.closeImage = Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("close.png")).getScaledInstance(24, 24, 4);
        this.closeLabel = new JLabel(new ImageIcon(this.closeImage));
        this.closeLabel.setSize(24, 24);
        this.closeLabel.setLocation(this.getSize().width - 48, (int)(this.getSize().getHeight() - 24.0) / 2 - 5);
        this.closeLabel.setCursor(new Cursor(12));
        this.closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (null != HeaderPanel.this.headerPresenter) {
                    HeaderPanel.this.headerPresenter.onExit();
                }
            }
        });
        this.add((Component)this.closeLabel, componentIndex++);
        this.settingsImage = Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("settings.png")).getScaledInstance(32, 32, 4);
        this.settingsLabel = new JLabel(new ImageIcon(this.settingsImage));
        this.settingsLabel.setSize(32, 32);
        this.settingsLabel.setLocation(this.getSize().width - 96, (int)(this.getSize().getHeight() - 32.0) / 2 - 5);
        this.settingsLabel.setCursor(new Cursor(12));
        this.settingsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (null != HeaderPanel.this.headerPresenter) {
                    HeaderPanel.this.headerPresenter.onGotoSettings();
                }
            }
        });
        this.add((Component)this.settingsLabel, componentIndex++);
        this.walletImage = Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("wallet.png")).getScaledInstance(32, 32, 4);
        this.walletLabel = new JLabel(new ImageIcon(this.walletImage));
        this.walletLabel.setSize(32, 32);
        this.walletLabel.setLocation(this.getSize().width - 144, (int)(this.getSize().getHeight() - 32.0) / 2 - 5);
        this.walletLabel.setCursor(new Cursor(12));
        this.walletLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (null != HeaderPanel.this.headerPresenter) {
                    HeaderPanel.this.headerPresenter.onGotoWallet();
                }
            }
        });
        this.add((Component)this.walletLabel, componentIndex++);
        this.orderImage = Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("order.png")).getScaledInstance(32, 32, 4);
        this.orderLabel = new JLabel(new ImageIcon(this.orderImage));
        this.orderLabel.setSize(32, 32);
        this.orderLabel.setLocation(this.getSize().width - 192, (int)(this.getSize().getHeight() - 32.0) / 2 - 5);
        this.orderLabel.setCursor(new Cursor(12));
        this.orderLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (null != HeaderPanel.this.headerPresenter) {
                    HeaderPanel.this.headerPresenter.onGotoOrder();
                }
            }
        });
        this.add((Component)this.orderLabel, componentIndex++);
    }

    @Override
    protected void paintComponent(Graphics2D g2D) {
        super.paintComponent(g2D);
        g2D.setColor(Color.WHITE);
        g2D.fillRoundRect(0, 0, this.getSize().width, this.getSize().height - 10, 16, 16);
        g2D.fillRect(0, this.getSize().height - 34, this.getSize().width, 24);
        g2D.drawImage(this.logo, 16, 8, this.logo.getWidth(this) / 4, this.logo.getHeight(this) / 4, this);
        g2D.drawImage(this.subLogo, 32 + this.logo.getWidth(this) / 4, 16, this.subLogo.getWidth(this) / 6, this.subLogo.getHeight(this) / 6, this);
        GradientPaint gp = new GradientPaint(0.0f, 72.0f, new Color(128, 128, 128, 128), 0.0f, 82.0f, new Color(128, 128, 128, 0));
        g2D.setPaint(gp);
        g2D.fillRect(0, 72, this.getSize().width, 10);
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public void setPresenter(HeaderPresenter headerPresenter) {
        this.headerPresenter = headerPresenter;
    }

    public static HeaderView newInstance() {
        return new HeaderPanel();
    }
}

