/*
 * Decompiled with CFR 0.152.
 */
package network.quant.compoent;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JLabel;
import network.quant.utils.UITools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Button
extends JButton {
    private static final Logger log = LoggerFactory.getLogger(Button.class);
    private static final Color OK_COLOR = new Color(38, 31, 99);
    private static final Color NORMAL_COLOR = new Color(59, 222, 200);
    private static final Color CANCEL_COLOR = Color.WHITE;
    private TYPE type;
    private JLabel text;

    public Button(String name, TYPE type) {
        this.type = type;
        this.setCursor(new Cursor(12));
        this.text = new JLabel(name);
        this.text.setHorizontalAlignment(0);
        this.text.setVerticalAlignment(0);
        this.text.setForeground(TYPE.OK.equals((Object)this.type) ? CANCEL_COLOR : OK_COLOR);
        this.text.setFont(UITools.getFont(1, 16.0f));
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.text.setSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.text.setSize(width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (TYPE.OK.equals((Object)this.type)) {
            graphics2D.setColor(OK_COLOR);
        } else if (TYPE.NORMAL.equals((Object)this.type)) {
            graphics2D.setColor(NORMAL_COLOR);
        } else {
            graphics2D.setColor(CANCEL_COLOR);
        }
        graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (TYPE.OK.equals((Object)this.type) || TYPE.NORMAL.equals((Object)this.type)) {
            graphics2D.setColor(CANCEL_COLOR);
        } else {
            graphics2D.setColor(OK_COLOR);
        }
        this.text.paint(graphics2D);
    }

    public static enum TYPE {
        OK,
        CANCEL,
        NORMAL;

    }
}

