/*
 * Decompiled with CFR 0.152.
 */
package network.quant.utils;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITools {
    private static final Logger log = LoggerFactory.getLogger(UITools.class);
    private static Font REGULAR;
    private static Font BOLD;

    private static void setFont() {
        try {
            REGULAR = Font.createFont(0, Thread.currentThread().getContextClassLoader().getResourceAsStream("font/OpenSans-Regular.ttf"));
            BOLD = Font.createFont(0, Thread.currentThread().getContextClassLoader().getResourceAsStream("font/OpenSans-Bold.ttf"));
        }
        catch (Exception e) {
            log.error("Unable to load font");
        }
    }

    public static Font getFont(int type, float size) {
        if (1 == type) {
            return BOLD.deriveFont(size);
        }
        return REGULAR.deriveFont(size);
    }

    static {
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(Font.createFont(0, Thread.currentThread().getContextClassLoader().getResourceAsStream("font/OpenSans-Regular.ttf")));
            ge.registerFont(Font.createFont(0, Thread.currentThread().getContextClassLoader().getResourceAsStream("font/OpenSans-Bold.ttf")));
            UITools.setFont();
        }
        catch (Exception e) {
            log.error("Unable to load font");
        }
    }
}

