/*
 * Decompiled with CFR 0.152.
 */
package network.quant.mvp.impl;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import network.quant.api.OverledgerTransaction;
import network.quant.compoent.ApplicationFrame;
import network.quant.compoent.ContentPanel;
import network.quant.compoent.HeaderPanel;
import network.quant.compoent.RootPanel;
import network.quant.essential.dto.OverledgerTransactionResponse;
import network.quant.event.ApplicationDataHandler;
import network.quant.event.ApplicationExitHandler;
import network.quant.event.ApplicationHistoryEvent;
import network.quant.mvp.Factory;
import network.quant.mvp.impl.ContentPresenterImpl;
import network.quant.mvp.impl.HeaderPresenterImpl;
import network.quant.mvp.presenter.ContentPresenter;
import network.quant.mvp.presenter.HeaderPresenter;
import network.quant.sdk.OverledgerSDKHelper;
import network.quant.util.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationFactory
implements Factory,
ApplicationExitHandler,
ApplicationDataHandler {
    private static final Logger log = LoggerFactory.getLogger(ApplicationFactory.class);
    private static Factory I;
    private ApplicationHistoryEvent applicationHistoryEvent;
    private ApplicationFrame applicationFrame;
    private HeaderPresenter headerPresenter;
    private ContentPresenter contentPresenter;

    @Override
    public void config() {
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                // empty catch block
            }
            this.getApplicationFrame().setVisible(true);
        });
    }

    @Override
    public ApplicationHistoryEvent getHistoryHandler() {
        if (null == this.applicationHistoryEvent) {
            this.applicationHistoryEvent = new ApplicationHistoryEvent(this.getContentPresenter());
        }
        return this.applicationHistoryEvent;
    }

    @Override
    public void onExit() {
        this.applicationFrame.setVisible(false);
        System.exit(0);
    }

    @Override
    public void onLoadSetting(String bpiKey, String mappId, String writeTransactions, String readTransactionsByMappId, String readTransactionsByMappIdPage, String readTransactionsByTransactionId, String readTransactionsByTransactionHash, String searchTransaction, String searchAddress, String searchBlocks, String balances) {
        this.getContentPresenter().loadSettings(bpiKey, mappId, writeTransactions, readTransactionsByMappId, readTransactionsByMappIdPage, readTransactionsByTransactionId, readTransactionsByTransactionHash, searchTransaction, searchAddress, searchBlocks, balances);
    }

    @Override
    public void onAccountGenerated(String type, String secretKey, String address) {
        this.contentPresenter.loadWallet(type, secretKey, address);
    }

    @Override
    public void onAccountReceived(String type, int amount) {
        this.contentPresenter.loadWallet(type, amount);
    }

    @Override
    public void onPurchaseFailed(String message) {
        this.contentPresenter.purchaseFailed(message);
    }

    @Override
    public void onPurchaseSuccess(OverledgerTransaction transaction) {
        this.contentPresenter.purchaseSuccess(transaction);
    }

    @Override
    public void onPurchaseSuccess(UUID overledgerTransactionId) {
        this.contentPresenter.purchaseSuccess(overledgerTransactionId);
    }

    @Override
    public void onLoadOrders(List<OverledgerTransaction> readTransactions, Page page) {
        this.contentPresenter.loadOrders(readTransactions, page);
    }

    @Override
    public void onLoadOrders(OverledgerTransactionResponse[] writeOverledgerTransactionResponses) {
        this.contentPresenter.loadOrders(writeOverledgerTransactionResponses);
    }

    private HeaderPresenter getHeaderPresenter() {
        if (null == this.headerPresenter) {
            this.headerPresenter = HeaderPresenterImpl.newInstance(HeaderPanel.newInstance(), this.getHistoryHandler(), this);
        }
        return this.headerPresenter;
    }

    private ContentPresenter getContentPresenter() {
        if (null == this.contentPresenter) {
            this.contentPresenter = ContentPresenterImpl.newInstance(ContentPanel.newInstance(), OverledgerSDKHelper.getInstance(this));
        }
        return this.contentPresenter;
    }

    private RootPanel getRootPanel() {
        return RootPanel.newInstance(this.getHeaderPresenter().asView(), this.getContentPresenter().asView());
    }

    private ApplicationFrame getApplicationFrame() {
        if (null == this.applicationFrame) {
            this.applicationFrame = ApplicationFrame.newInstance(this.getRootPanel());
        }
        return this.applicationFrame;
    }

    public static Factory getInstance() {
        Optional<Factory> optional = Optional.ofNullable(I);
        I = new ApplicationFactory();
        return optional.orElse(I);
    }
}

