/*
 * Decompiled with CFR 0.152.
 */
package network.quant.compoent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import network.quant.compoent.BaseComponent;
import network.quant.compoent.Button;
import network.quant.mvp.presenter.ContentPresenter;
import network.quant.utils.UITools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsPanel
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(SettingsPanel.class);
    private static final Color TEXT = new Color(38, 31, 99);
    private ContentPresenter contentPresenter;
    private JLabel bpiKeyLabel = new JLabel("BPI Key");
    private JLabel mappIdLabel = new JLabel("Mapp Id");
    private JLabel writeLabel = new JLabel("Write Endpoint");
    private JLabel readByMappIdLabel = new JLabel("Read by MappID Endpoint");
    private JLabel readByMappIdPageLabel = new JLabel("Read by MappID (Page) Endpoint");
    private JLabel readByIdLabel = new JLabel("Read by ID Endpoint");
    private JLabel readByHashLabel = new JLabel("Read by Hash Endpoint");
    private JLabel searchTransactionLabel = new JLabel("Search Txn Endpoint");
    private JLabel searchAddressLabel = new JLabel("Search Address Endpoint");
    private JLabel searchBlocksLabel = new JLabel("Search blocks Endpoint");
    private JLabel balancesLabel = new JLabel("Balances Endpoint");
    public JTextField bpiKeyField = new JTextField();
    public JTextField mappIdField = new JTextField();
    public JTextField writeField = new JTextField();
    public JTextField readByMappIdField = new JTextField();
    public JTextField readByMappIdPageField = new JTextField();
    public JTextField readByIdField = new JTextField();
    public JTextField readByHashField = new JTextField();
    public JTextField searchTransactionField = new JTextField();
    public JTextField searchAddressField = new JTextField();
    public JTextField searchBlocksField = new JTextField();
    public JTextField balancesField = new JTextField();
    private Button okButton = new Button("OK", Button.TYPE.OK);
    private Button cancelButton = new Button("CANCEL", Button.TYPE.CANCEL);

    public SettingsPanel(Dimension dimension, final ContentPresenter contentPresenter) {
        super(dimension);
        this.contentPresenter = contentPresenter;
        this.setDropTarget(new DropTarget(this, 3, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        List fileList;
                        dtde.acceptDrop(dtde.getDropAction());
                        Object transaferData = dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        if (null != transaferData && transaferData instanceof List && !(fileList = (List)transaferData).isEmpty()) {
                            contentPresenter.loadSettingsPropertiesFromFile((File)fileList.get(0));
                            dtde.dropComplete(true);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Unable to preform DnD", (Throwable)e);
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
        }));
        int componentIndex = 0;
        JLabel label = new JLabel("Settings");
        label.setSize(dimension.width - 20, 64);
        label.setLocation(10, 10);
        label.setFont(UITools.getFont(0, 48.0f));
        label.setForeground(TEXT);
        this.add((Component)label, componentIndex++);
        this.bpiKeyLabel.setSize(300, 32);
        this.bpiKeyLabel.setLocation(10, 110);
        this.bpiKeyLabel.setFont(UITools.getFont(1, 16.0f));
        this.bpiKeyLabel.setForeground(TEXT);
        this.add((Component)this.bpiKeyLabel, componentIndex++);
        this.bpiKeyField.setSize(dimension.width - 220, 32);
        this.bpiKeyField.setLocation(310, 110);
        this.bpiKeyField.setFont(UITools.getFont(0, 16.0f));
        this.bpiKeyField.setForeground(TEXT);
        this.add((Component)this.bpiKeyField, componentIndex++);
        this.mappIdLabel.setSize(300, 32);
        this.mappIdLabel.setLocation(10, 150);
        this.mappIdLabel.setFont(UITools.getFont(1, 16.0f));
        this.mappIdLabel.setForeground(TEXT);
        this.add((Component)this.mappIdLabel, componentIndex++);
        this.mappIdField.setSize(dimension.width - 220, 32);
        this.mappIdField.setLocation(310, 150);
        this.mappIdField.setFont(UITools.getFont(0, 16.0f));
        this.mappIdField.setForeground(TEXT);
        this.add((Component)this.mappIdField, componentIndex++);
        this.writeLabel.setSize(300, 32);
        this.writeLabel.setLocation(10, 230);
        this.writeLabel.setFont(UITools.getFont(1, 16.0f));
        this.writeLabel.setForeground(TEXT);
        this.add((Component)this.writeLabel, componentIndex++);
        this.writeField.setSize(dimension.width - 220, 32);
        this.writeField.setLocation(310, 230);
        this.writeField.setFont(UITools.getFont(0, 16.0f));
        this.writeField.setForeground(TEXT);
        this.add((Component)this.writeField, componentIndex++);
        this.readByMappIdLabel.setSize(300, 32);
        this.readByMappIdLabel.setLocation(10, 270);
        this.readByMappIdLabel.setFont(UITools.getFont(1, 16.0f));
        this.readByMappIdLabel.setForeground(TEXT);
        this.add((Component)this.readByMappIdLabel, componentIndex++);
        this.readByMappIdField.setSize(dimension.width - 220, 32);
        this.readByMappIdField.setLocation(310, 270);
        this.readByMappIdField.setFont(UITools.getFont(0, 16.0f));
        this.readByMappIdField.setForeground(TEXT);
        this.add((Component)this.readByMappIdField, componentIndex++);
        this.readByMappIdPageLabel.setSize(300, 32);
        this.readByMappIdPageLabel.setLocation(10, 310);
        this.readByMappIdPageLabel.setFont(UITools.getFont(1, 16.0f));
        this.readByMappIdPageLabel.setForeground(TEXT);
        this.add((Component)this.readByMappIdPageLabel, componentIndex++);
        this.readByMappIdPageField.setSize(dimension.width - 220, 32);
        this.readByMappIdPageField.setLocation(310, 310);
        this.readByMappIdPageField.setFont(UITools.getFont(0, 16.0f));
        this.readByMappIdPageField.setForeground(TEXT);
        this.add((Component)this.readByMappIdPageField, componentIndex++);
        this.readByIdLabel.setSize(300, 32);
        this.readByIdLabel.setLocation(10, 350);
        this.readByIdLabel.setFont(UITools.getFont(1, 16.0f));
        this.readByIdLabel.setForeground(TEXT);
        this.add((Component)this.readByIdLabel, componentIndex++);
        this.readByIdField.setSize(dimension.width - 220, 32);
        this.readByIdField.setLocation(310, 350);
        this.readByIdField.setFont(UITools.getFont(0, 16.0f));
        this.readByIdField.setForeground(TEXT);
        this.add((Component)this.readByIdField, componentIndex++);
        this.readByHashLabel.setSize(300, 32);
        this.readByHashLabel.setLocation(10, 390);
        this.readByHashLabel.setFont(UITools.getFont(1, 16.0f));
        this.readByHashLabel.setForeground(TEXT);
        this.add((Component)this.readByHashLabel, componentIndex++);
        this.readByHashField.setSize(dimension.width - 220, 32);
        this.readByHashField.setLocation(310, 390);
        this.readByHashField.setFont(UITools.getFont(0, 16.0f));
        this.readByHashField.setForeground(TEXT);
        this.add((Component)this.readByHashField, componentIndex++);
        this.searchTransactionLabel.setSize(300, 32);
        this.searchTransactionLabel.setLocation(10, 430);
        this.searchTransactionLabel.setFont(UITools.getFont(1, 16.0f));
        this.searchTransactionLabel.setForeground(TEXT);
        this.add((Component)this.searchTransactionLabel, componentIndex++);
        this.searchTransactionField.setSize(dimension.width - 220, 32);
        this.searchTransactionField.setLocation(310, 430);
        this.searchTransactionField.setFont(UITools.getFont(0, 16.0f));
        this.searchTransactionField.setForeground(TEXT);
        this.add((Component)this.searchTransactionField, componentIndex++);
        this.searchAddressLabel.setSize(300, 32);
        this.searchAddressLabel.setLocation(10, 470);
        this.searchAddressLabel.setFont(UITools.getFont(1, 16.0f));
        this.searchAddressLabel.setForeground(TEXT);
        this.add((Component)this.searchAddressLabel, componentIndex++);
        this.searchAddressField.setSize(dimension.width - 220, 32);
        this.searchAddressField.setLocation(310, 470);
        this.searchAddressField.setFont(UITools.getFont(0, 16.0f));
        this.searchAddressField.setForeground(TEXT);
        this.add((Component)this.searchAddressField, componentIndex++);
        this.searchBlocksLabel.setSize(300, 32);
        this.searchBlocksLabel.setLocation(10, 520);
        this.searchBlocksLabel.setFont(UITools.getFont(1, 16.0f));
        this.searchBlocksLabel.setForeground(TEXT);
        this.add((Component)this.searchBlocksLabel, componentIndex++);
        this.searchBlocksField.setSize(dimension.width - 220, 32);
        this.searchBlocksField.setLocation(310, 520);
        this.searchBlocksField.setFont(UITools.getFont(0, 16.0f));
        this.searchBlocksField.setForeground(TEXT);
        this.add((Component)this.searchBlocksField, componentIndex++);
        this.balancesLabel.setSize(300, 32);
        this.balancesLabel.setLocation(10, 560);
        this.balancesLabel.setFont(UITools.getFont(1, 16.0f));
        this.balancesLabel.setForeground(TEXT);
        this.add((Component)this.balancesLabel, componentIndex++);
        this.balancesField.setSize(dimension.width - 220, 32);
        this.balancesField.setLocation(310, 560);
        this.balancesField.setFont(UITools.getFont(0, 16.0f));
        this.balancesField.setForeground(TEXT);
        this.add((Component)this.balancesField, componentIndex++);
        this.okButton.setSize(150, 48);
        this.okButton.setLocation(dimension.width - 150, dimension.height - 50);
        this.okButton.addActionListener(event -> this.contentPresenter.onGotoMainWithUpdate(this.bpiKeyField.getText(), this.mappIdField.getText(), this.writeField.getText(), this.readByMappIdField.getText(), this.readByIdField.getText(), this.readByHashField.getText()));
        this.add((Component)this.okButton, componentIndex++);
        this.cancelButton.setSize(150, 48);
        this.cancelButton.setLocation(dimension.width - 320, dimension.height - 50);
        this.cancelButton.addActionListener(event -> this.contentPresenter.onGotoMain());
        this.add((Component)this.cancelButton, componentIndex++);
    }
}

