/*
 * Decompiled with CFR 0.152.
 */
package network.quant.compoent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JLabel;
import network.quant.compoent.BaseComponent;
import network.quant.compoent.BikeCard;
import network.quant.compoent.Button;
import network.quant.compoent.InsuranceComponent;
import network.quant.compoent.PaymentComponent;
import network.quant.compoent.RoadTaxComponent;
import network.quant.mvp.presenter.ContentPresenter;
import network.quant.utils.UITools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailPanel
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(DetailPanel.class);
    private static final Color TEXT = new Color(38, 31, 99);
    private ContentPresenter contentPresenter;
    private JLabel title;
    private BikeCard card;
    private PaymentComponent paymentComponent;
    private InsuranceComponent insuranceComponent;
    private RoadTaxComponent roadTaxComponent;
    private Button okButton = new Button("PURCHASE", Button.TYPE.OK);
    private Button cancelButton = new Button("CANCEL", Button.TYPE.CANCEL);

    public DetailPanel(Dimension dimension, ContentPresenter contentPresenter) {
        super(dimension);
        this.contentPresenter = contentPresenter;
        int componentIndex = 0;
        this.title = new JLabel("Motorcycle Shop");
        this.title.setSize(dimension.width - 20, 64);
        this.title.setLocation(10, 10);
        this.title.setFont(UITools.getFont(0, 48.0f));
        this.title.setForeground(TEXT);
        this.add((Component)this.title, componentIndex++);
        this.paymentComponent = new PaymentComponent(new Dimension(dimension.width - 40 - 300 - 10, 250));
        this.paymentComponent.setLocation(330, 100);
        this.add((Component)this.paymentComponent, componentIndex++);
        this.insuranceComponent = new InsuranceComponent(new Dimension(dimension.width - 40 - 300 - 10 - 300, 180));
        this.insuranceComponent.setLocation(330, 360);
        this.add((Component)this.insuranceComponent, componentIndex++);
        this.roadTaxComponent = new RoadTaxComponent(new Dimension(290, 180));
        this.roadTaxComponent.setLocation(dimension.width - 310, 360);
        this.add((Component)this.roadTaxComponent, componentIndex++);
        this.okButton.setSize(150, 48);
        this.okButton.setLocation(dimension.width - 150, dimension.height - 50);
        this.okButton.addActionListener(event -> this.contentPresenter.onPurchase(this.paymentComponent.payment.getText(), this.paymentComponent.reg.getText(), this.paymentComponent.contactFile, this.insuranceComponent.policy.getText(), this.insuranceComponent.premium.getText(), this.roadTaxComponent.annual.getText()));
        this.add((Component)this.okButton, componentIndex++);
        this.cancelButton.setSize(150, 48);
        this.cancelButton.setLocation(dimension.width - 320, dimension.height - 50);
        this.cancelButton.addActionListener(event -> this.contentPresenter.onGotoMain());
        this.add((Component)this.cancelButton, componentIndex++);
    }

    public void display(int index) {
        int componentIndex = 3;
        if (index == 0) {
            this.title.setText("XSR900");
            this.card = new BikeCard(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("bikes/XSR900.jpg")), "XSR900", "1.6 BTC");
            this.card.setLocation(20, 100);
            this.add((Component)this.card, componentIndex++);
        } else if (index == 1) {
            this.title.setText("XSR700");
            this.card = new BikeCard(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("bikes/XSR700.jpg")), "XSR700", "1.2 BTC");
            this.card.setLocation(20, 100);
            this.add((Component)this.card, componentIndex++);
        } else if (index == 2) {
            this.title.setText("Z900RS");
            this.card = new BikeCard(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("bikes/Z900RS.jpg")), "Z900RS", "2 BTC");
            this.card.setLocation(20, 100);
            this.add((Component)this.card, componentIndex++);
        }
    }
}

