/*
 * Decompiled with CFR 0.152.
 */
package network.quant.compoent;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import network.quant.compoent.BaseComponent;
import network.quant.compoent.DetailPanel;
import network.quant.compoent.OrderPanel;
import network.quant.compoent.SettingsPanel;
import network.quant.compoent.WalletPanel;
import network.quant.compoent.WelcomePanel;
import network.quant.mvp.impl.ANCHOR;
import network.quant.mvp.presenter.ContentPresenter;
import network.quant.mvp.view.ContentView;

public class ContentPanel
extends BaseComponent
implements ContentView {
    private ContentPresenter contentPresenter;
    private Map<ANCHOR, BaseComponent> viewBag = new HashMap<ANCHOR, BaseComponent>();
    private BaseComponent currentView;
    private ANCHOR currentAnchor;

    private ContentPanel() {
        super(new Dimension(1024, 686));
    }

    private BaseComponent loadView(ANCHOR anchor) {
        if (!this.viewBag.containsKey((Object)anchor)) {
            switch (anchor) {
                case ORDER: {
                    this.viewBag.put(anchor, new OrderPanel(new Dimension(this.getSize().width - 40, this.getSize().height - 40), this.contentPresenter));
                    break;
                }
                case WALLET: {
                    this.viewBag.put(anchor, new WalletPanel(new Dimension(this.getSize().width - 40, this.getSize().height - 40), this.contentPresenter));
                    break;
                }
                case SETTINGS: {
                    this.viewBag.put(anchor, new SettingsPanel(new Dimension(this.getSize().width - 40, this.getSize().height - 40), this.contentPresenter));
                    break;
                }
                case DETAILS: {
                    this.viewBag.put(anchor, new DetailPanel(new Dimension(this.getSize().width - 40, this.getSize().height - 40), this.contentPresenter));
                    break;
                }
                default: {
                    this.viewBag.put(anchor, new WelcomePanel(new Dimension(this.getSize().width - 40, this.getSize().height - 40), this.contentPresenter));
                }
            }
        }
        return this.viewBag.get((Object)anchor);
    }

    @Override
    public void setPresenter(ContentPresenter contentPresenter) {
        this.contentPresenter = contentPresenter;
        this.changeTo(ANCHOR.WELCOME);
    }

    @Override
    public void changeTo(ANCHOR anchor) {
        if (null != this.currentAnchor && this.currentAnchor.equals((Object)anchor)) {
            return;
        }
        if (null != this.currentView) {
            this.remove(this.currentView);
        }
        this.currentView = this.loadView(anchor);
        if (null != this.currentView) {
            this.add((Component)this.currentView, 0);
            this.currentView.setLocation(20, 20);
        }
        this.currentAnchor = anchor;
        if (null != this.getParent()) {
            this.getParent().getParent().repaint();
        } else {
            this.repaint();
        }
        this.currentView.repaint();
    }

    @Override
    public SettingsPanel getCurrentViewAsSettingsPanel() {
        if (ANCHOR.SETTINGS.equals((Object)this.currentAnchor)) {
            return (SettingsPanel)this.currentView;
        }
        return null;
    }

    @Override
    public WalletPanel getCurrentViewAsWalletPanel() {
        if (ANCHOR.WALLET.equals((Object)this.currentAnchor)) {
            return (WalletPanel)this.currentView;
        }
        return null;
    }

    @Override
    public OrderPanel getCurrentViewAsOrderPanel() {
        if (ANCHOR.ORDER.equals((Object)this.currentAnchor)) {
            return (OrderPanel)this.currentView;
        }
        return null;
    }

    @Override
    public void showDetails(int index) {
        if (ANCHOR.DETAILS.equals((Object)this.currentAnchor)) {
            ((DetailPanel)this.currentView).display(index);
        }
    }

    @Override
    public Component asComponent() {
        return this;
    }

    public static ContentView newInstance() {
        return new ContentPanel();
    }
}

