/*
 * Decompiled with CFR 0.152.
 */
package network.quant.compoent;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import javax.swing.JLabel;
import network.quant.compoent.BaseComponent;
import network.quant.utils.UITools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BikeCard
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(BikeCard.class);
    private static final Color BASE = new Color(38, 31, 99);
    private static final Color NORMA = new Color(59, 222, 200);
    private Polygon polygon;
    private Image image;
    private JLabel name;
    private JLabel price;

    public BikeCard(Image image, String name, String price) {
        super(new Dimension(300, 400));
        this.image = image.getScaledInstance(280, 280 * image.getHeight(this) / image.getWidth(this), 4);
        int[] xPolygon = new int[]{200, 300, 300};
        int[] yPolygon = new int[]{0, 100, 0};
        this.polygon = new Polygon(xPolygon, yPolygon, 3);
        this.name = new JLabel(name);
        this.name.setForeground(Color.WHITE);
        this.name.setHorizontalAlignment(0);
        this.name.setVerticalAlignment(0);
        this.name.setSize(300, 56);
        this.name.setFont(UITools.getFont(0, 24.0f));
        this.price = new JLabel(price);
        this.price.setForeground(Color.WHITE);
        this.price.setHorizontalAlignment(0);
        this.price.setVerticalAlignment(0);
        this.price.setSize(100, 56);
        this.price.setFont(UITools.getFont(0, 16.0f));
        this.setCursor(new Cursor(12));
    }

    @Override
    protected void paintComponent(Graphics2D g2D) {
        super.paintComponent(g2D);
        g2D.setColor(Color.WHITE);
        g2D.fillRoundRect(0, 0, this.getSize().width, this.getSize().height, 16, 16);
        g2D.drawImage(this.image, 10, 10, this);
        g2D.setColor(BASE);
        g2D.fillRoundRect(0, this.getSize().height - 56, this.getSize().width, 56, 16, 16);
        g2D.fillRect(0, this.getSize().height - 56, this.getSize().width, 20);
        this.name.paint(g2D.create(0, this.getSize().height - 56, 300, 56));
        g2D.setColor(NORMA);
        g2D.fillPolygon(this.polygon);
        this.price.paint(g2D.create(215, 0, 100, 56));
    }
}

