/*
 * Decompiled with CFR 0.152.
 */
package network.quant.ethereum.experimental;

import java.math.BigDecimal;
import java.math.BigInteger;
import network.quant.ethereum.EthereumAccount;
import network.quant.ethereum.experimental.dto.FaucetResponseDto;
import network.quant.exception.ClientResponseException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClient;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;

public class EthereumFaucetHelper {
    private static EthereumFaucetHelper I;
    private WebClient webClient = WebClient.create();
    private String url;

    private EthereumFaucetHelper() {
    }

    public void fundAccount(EthereumAccount ethereumAccount) {
        String address = Credentials.create((ECKeyPair)ethereumAccount.getEcKeyPair()).getAddress();
        ((WebClient.RequestBodySpec)this.webClient.post().uri(this.url, new Object[]{address, new BigDecimal("1000000000000000000")})).retrieve().onStatus(HttpStatus::is4xxClientError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).onStatus(HttpStatus::is5xxServerError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).bodyToMono(FaucetResponseDto.class).doOnSuccess(faucetResponseDto -> ethereumAccount.setNonce(BigInteger.ZERO)).doOnError(RuntimeException::new).block();
    }

    public static EthereumFaucetHelper getInstance(String url) {
        if (null == I) {
            I = new EthereumFaucetHelper();
        }
        EthereumFaucetHelper.I.url = url;
        return I;
    }
}

