/*
 * Decompiled with CFR 0.152.
 */
package network.quant.ethereum;

import java.math.BigInteger;
import network.quant.api.FEE_POLICY;
import network.quant.ethereum.EthGasAPI;
import network.quant.ethereum.FeePolicy;
import network.quant.ethereum.exception.EthGasStationRequestFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClient;

public class EthGasStation
implements FeePolicy {
    private static final Logger log = LoggerFactory.getLogger(EthGasStation.class);
    private static final String GAS_URL = "https://ethgasstation.info/json/ethgasAPI.json";
    private static final long REFRESH_TIME = 60000L;
    private static EthGasStation I;
    private long lastUpdate = -1L;
    private WebClient webClient = WebClient.create((String)"https://ethgasstation.info/json/ethgasAPI.json");
    private BigInteger priority = new BigInteger("230");
    private BigInteger normal = new BigInteger("125");
    private BigInteger economy = new BigInteger("120");

    private EthGasStation() {
    }

    private void getGases() {
        EthGasAPI ethGasAPI = (EthGasAPI)this.webClient.get().retrieve().onStatus(HttpStatus::is4xxClientError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(EthGasStationRequestFailedException::new)).onStatus(HttpStatus::is5xxServerError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(EthGasStationRequestFailedException::new)).bodyToMono(EthGasAPI.class).block();
        if (null != ethGasAPI) {
            this.priority = BigInteger.valueOf(ethGasAPI.getFastest().longValue());
            this.normal = BigInteger.valueOf(ethGasAPI.getFast().longValue());
            this.economy = BigInteger.valueOf(ethGasAPI.getAverage().longValue());
        }
    }

    private void updateGases() {
        long now = System.currentTimeMillis();
        if (this.lastUpdate < 0L || now - this.lastUpdate > 60000L) {
            try {
                this.getGases();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lastUpdate = now;
        }
    }

    @Override
    public BigInteger calculate(FEE_POLICY fee_policy) {
        try {
            this.updateGases();
        }
        catch (Exception e) {
            log.warn("Unable to connect to ethgasstation service", (Throwable)e);
        }
        switch (fee_policy) {
            case PRIORITY: {
                return this.priority;
            }
            case NORMAL: {
                return this.normal;
            }
            case ECONOMY: {
                return this.economy;
            }
        }
        return this.normal;
    }

    static EthGasStation getInstance() {
        if (null == I) {
            I = new EthGasStation();
        }
        return I;
    }
}

