/*
 * Decompiled with CFR 0.152.
 */
package network.quant.ethereum.experimental;

import java.math.BigDecimal;
import java.math.BigInteger;
import network.quant.OverledgerContext;
import network.quant.api.NETWORK;
import network.quant.ethereum.EthereumAccount;
import network.quant.exception.ClientResponseException;
import network.quant.exception.RedirectException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import reactor.core.publisher.Mono;

public class EthereumFaucetHelper {
    private static final String BEARER = "Bearer";
    private static EthereumFaucetHelper I;
    private WebClient webClient = WebClient.builder().defaultHeader("Authorization", new String[]{String.format("%s %s:%s", "Bearer", OverledgerContext.MAPP_ID, OverledgerContext.BPI_KEY)}).build();
    private String url;

    private EthereumFaucetHelper() {
    }

    private void redirectPost(EthereumAccount ethereumAccount, String uri, BigInteger nonce) {
        ((WebClient.RequestBodySpec)this.webClient.post().uri(uri, new Object[0])).contentType(MediaType.APPLICATION_JSON_UTF8).retrieve().onStatus(HttpStatus::is4xxClientError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).onStatus(HttpStatus::is5xxServerError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).bodyToMono(String.class).doOnSuccess(faucetResponseDto -> ethereumAccount.setNonce(null != nonce ? nonce : BigInteger.ZERO)).doOnError(RuntimeException::new).block();
    }

    public void fundAccount(EthereumAccount ethereumAccount, BigInteger nonce) {
        if (null != ethereumAccount && NETWORK.TEST.equals((Object)ethereumAccount.getNetwork())) {
            try {
                String address = Credentials.create((ECKeyPair)ethereumAccount.getEcKeyPair()).getAddress();
                ((WebClient.RequestBodySpec)this.webClient.post().uri(this.url, new Object[]{address, new BigDecimal("1000000000000000000")})).retrieve().onStatus(HttpStatus::is4xxClientError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).onStatus(HttpStatus::is5xxServerError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header("Location").get(0)))).bodyToMono(String.class).doOnSuccess(faucetResponseDto -> ethereumAccount.setNonce(null != nonce ? nonce : BigInteger.ZERO)).doOnError(RuntimeException::new).block();
            }
            catch (RedirectException e) {
                this.redirectPost(ethereumAccount, e.getUrl(), nonce);
            }
        }
    }

    public void fundAccount(EthereumAccount ethereumAccount) {
        this.fundAccount(ethereumAccount, BigInteger.ZERO);
    }

    public static EthereumFaucetHelper getInstance(String url) {
        if (null == I) {
            I = new EthereumFaucetHelper();
        }
        EthereumFaucetHelper.I.url = url;
        return I;
    }
}

