/*
 * Decompiled with CFR 0.152.
 */
package network.quant.ethereum;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import network.quant.api.Account;
import network.quant.api.Compressor;
import network.quant.api.DltTransaction;
import network.quant.api.DltTransactionRequest;
import network.quant.api.Encryptor;
import network.quant.api.FEE_POLICY;
import network.quant.api.NETWORK;
import network.quant.ethereum.EthGasStation;
import network.quant.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.utils.Numeric;

public class EthereumAccount
implements Account {
    private static final Logger log = LoggerFactory.getLogger(EthereumAccount.class);
    private static final BigInteger DEFAULT_MAIN_GAS_LIMIT = new BigInteger("8000000");
    private static final BigInteger DEFAULT_TEST_GAS_LIMIT = new BigInteger("4712388");
    private static EthereumAccount I;
    private NETWORK network;
    private ECKeyPair ecKeyPair;
    private BigInteger nonce;
    private BigInteger gasLimit;
    private Encryptor encryptor;
    private Compressor compressor;

    private EthereumAccount(NETWORK network) throws Exception {
        this(network, Keys.createEcKeyPair(), BigInteger.ZERO);
    }

    private EthereumAccount(NETWORK network, BigInteger privateKey, BigInteger nonce) {
        this(network, ECKeyPair.create((BigInteger)privateKey), nonce);
    }

    private EthereumAccount(NETWORK network, byte[] privateKey, BigInteger nonce) {
        this(network, ECKeyPair.create((byte[])privateKey), nonce);
    }

    private EthereumAccount(NETWORK network, ECKeyPair privateKey, BigInteger nonce) {
        this.network = network;
        this.ecKeyPair = privateKey;
        this.nonce = nonce;
        this.gasLimit = NETWORK.MAIN.equals((Object)this.network) ? DEFAULT_MAIN_GAS_LIMIT : DEFAULT_TEST_GAS_LIMIT;
    }

    private void sign(String toAddress, String message, DltTransactionRequest dltTransaction) {
        this.nonce = null != dltTransaction.getSequence() ? BigInteger.valueOf(dltTransaction.getSequence()) : this.nonce;
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)this.nonce, (BigInteger)Optional.ofNullable(dltTransaction.getFee()).orElse(EthGasStation.getInstance().calculate(FEE_POLICY.NORMAL)), (BigInteger)Optional.ofNullable(dltTransaction.getFeeLimit()).orElse(this.gasLimit), (String)toAddress, (BigInteger)dltTransaction.getAmount(), (String)message);
        byte[] transactionSignedBytes = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)Credentials.create((ECKeyPair)this.ecKeyPair));
        dltTransaction.setSignedTransaction(Numeric.toHexString((byte[])transactionSignedBytes));
        this.nonce = this.nonce.add(BigInteger.ONE);
    }

    public NETWORK getNetwork() {
        return this.network;
    }

    public Account withNetwork(NETWORK network) {
        this.network = network;
        return this;
    }

    public void setPrivateKey(BigInteger key) {
        this.ecKeyPair = ECKeyPair.create((BigInteger)key);
    }

    public BigInteger getPrivateKey() {
        return this.ecKeyPair.getPrivateKey();
    }

    public void sign(String fromAddress, String toAddress, String message, DltTransaction dltTransaction) {
        if (dltTransaction instanceof DltTransactionRequest) {
            byte[] data = message.getBytes();
            if (null != this.encryptor) {
                data = this.encryptor.encrypt(data);
                message = DatatypeConverter.printHexBinary((byte[])data);
            }
            if (null != this.compressor) {
                data = this.compressor.compress(data);
                message = DatatypeConverter.printHexBinary((byte[])data);
            }
            this.sign(toAddress, message, (DltTransactionRequest)dltTransaction);
        }
    }

    public void sign(String fromAddress, String toAddress, byte[] data, DltTransaction dltTransaction) {
        if (dltTransaction instanceof DltTransactionRequest) {
            String message = DatatypeConverter.printHexBinary((byte[])data);
            if (null != this.encryptor) {
                data = this.encryptor.encrypt(data);
                message = DatatypeConverter.printHexBinary((byte[])data);
            }
            if (null != this.compressor) {
                data = this.compressor.compress(data);
                message = DatatypeConverter.printHexBinary((byte[])data);
            }
            this.sign(toAddress, message, (DltTransactionRequest)dltTransaction);
        }
    }

    public void sign(String fromAddress, String toAddress, InputStream stream, DltTransaction dltTransaction) {
        if (dltTransaction instanceof DltTransactionRequest) {
            byte[] data;
            try {
                data = CommonUtil.getStream((InputStream)stream);
            }
            catch (IOException e) {
                log.error("Unalbe to read data from given stream", (Throwable)e);
                return;
            }
            String message = DatatypeConverter.printHexBinary((byte[])data);
            if (null != this.encryptor) {
                data = this.encryptor.encrypt(data);
                message = DatatypeConverter.printHexBinary((byte[])data);
            }
            if (null != this.compressor) {
                data = this.compressor.compress(data);
                message = DatatypeConverter.printHexBinary((byte[])data);
            }
            this.sign(toAddress, message, (DltTransactionRequest)dltTransaction);
        }
    }

    public static Account getInstance(NETWORK network, Encryptor encryptor, Compressor compressor) throws Exception {
        I = new EthereumAccount(network);
        EthereumAccount.I.encryptor = encryptor;
        EthereumAccount.I.compressor = compressor;
        return I;
    }

    public static Account getInstance(NETWORK network) throws Exception {
        I = new EthereumAccount(network);
        return I;
    }

    public static Account getInstance(NETWORK network, BigInteger privateKey, BigInteger nonce, Encryptor encryptor, Compressor compressor) {
        I = new EthereumAccount(network, privateKey, nonce);
        EthereumAccount.I.encryptor = encryptor;
        EthereumAccount.I.compressor = compressor;
        return I;
    }

    public static Account getInstance(NETWORK network, BigInteger privateKey, BigInteger nonce) {
        return EthereumAccount.getInstance(network, privateKey, nonce, null, null);
    }

    public static Account getInstance(NETWORK network, byte[] privateKey, BigInteger nonce, Encryptor encryptor, Compressor compressor) {
        I = new EthereumAccount(network, privateKey, nonce);
        EthereumAccount.I.encryptor = encryptor;
        EthereumAccount.I.compressor = compressor;
        return I;
    }

    public static Account getInstance(NETWORK network, byte[] privateKey, BigInteger nonce) {
        return EthereumAccount.getInstance(network, privateKey, nonce, null, null);
    }

    public static Account getInstance(NETWORK network, ECKeyPair privateKey, BigInteger nonce, Encryptor encryptor, Compressor compressor) {
        I = new EthereumAccount(network, privateKey, nonce);
        EthereumAccount.I.encryptor = encryptor;
        EthereumAccount.I.compressor = compressor;
        return I;
    }

    public static Account getInstance(NETWORK network, ECKeyPair privateKey, BigInteger nonce) {
        return EthereumAccount.getInstance(network, privateKey, nonce, null, null);
    }

    public ECKeyPair getEcKeyPair() {
        return this.ecKeyPair;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public void setNetwork(NETWORK network) {
        this.network = network;
    }

    public void setEcKeyPair(ECKeyPair ecKeyPair) {
        this.ecKeyPair = ecKeyPair;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public void setGasLimit(BigInteger gasLimit) {
        this.gasLimit = gasLimit;
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EthereumAccount)) {
            return false;
        }
        EthereumAccount other = (EthereumAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NETWORK this$network = this.getNetwork();
        NETWORK other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        ECKeyPair this$ecKeyPair = this.getEcKeyPair();
        ECKeyPair other$ecKeyPair = other.getEcKeyPair();
        if (this$ecKeyPair == null ? other$ecKeyPair != null : !this$ecKeyPair.equals(other$ecKeyPair)) {
            return false;
        }
        BigInteger this$nonce = this.getNonce();
        BigInteger other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        BigInteger this$gasLimit = this.getGasLimit();
        BigInteger other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
            return false;
        }
        Encryptor this$encryptor = this.getEncryptor();
        Encryptor other$encryptor = other.getEncryptor();
        if (this$encryptor == null ? other$encryptor != null : !this$encryptor.equals(other$encryptor)) {
            return false;
        }
        Compressor this$compressor = this.getCompressor();
        Compressor other$compressor = other.getCompressor();
        return !(this$compressor == null ? other$compressor != null : !this$compressor.equals(other$compressor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EthereumAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NETWORK $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        ECKeyPair $ecKeyPair = this.getEcKeyPair();
        result = result * 59 + ($ecKeyPair == null ? 43 : $ecKeyPair.hashCode());
        BigInteger $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        BigInteger $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        Encryptor $encryptor = this.getEncryptor();
        result = result * 59 + ($encryptor == null ? 43 : $encryptor.hashCode());
        Compressor $compressor = this.getCompressor();
        result = result * 59 + ($compressor == null ? 43 : $compressor.hashCode());
        return result;
    }

    public String toString() {
        return "EthereumAccount(network=" + this.getNetwork() + ", ecKeyPair=" + this.getEcKeyPair() + ", nonce=" + this.getNonce() + ", gasLimit=" + this.getGasLimit() + ", encryptor=" + this.getEncryptor() + ", compressor=" + this.getCompressor() + ")";
    }
}

