/*
 * Decompiled with CFR 0.152.
 */
package network.quant.essential.util;

import java.io.ByteArrayOutputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import network.quant.api.Compressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZlibCompressor
implements Compressor {
    private static final Logger log = LoggerFactory.getLogger(ZlibCompressor.class);

    private ZlibCompressor() {
    }

    public byte[] compress(byte[] bytes) {
        byte[] result;
        try {
            Deflater deflater = new Deflater();
            deflater.setLevel(9);
            deflater.setInput(bytes);
            deflater.finish();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bytes.length);
            byte[] buffer = new byte[2048];
            while (!deflater.finished()) {
                int size = deflater.deflate(buffer);
                byteArrayOutputStream.write(buffer, 0, size);
            }
            byteArrayOutputStream.close();
            result = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            log.error("Unable to compress target", (Throwable)e);
            result = null;
        }
        return result;
    }

    public byte[] decompress(byte[] bytes) {
        byte[] result;
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(bytes);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bytes.length);
            byte[] buffer = new byte[2048];
            while (!inflater.finished()) {
                int size = inflater.inflate(buffer);
                byteArrayOutputStream.write(buffer, 0, size);
            }
            byteArrayOutputStream.close();
            result = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            log.error("Unable to decompress target", (Throwable)e);
            result = null;
        }
        return result;
    }

    public static Compressor newInstance() {
        return new ZlibCompressor();
    }
}

