/*
 * Decompiled with CFR 0.152.
 */
package network.quant.essential;

import java.util.List;
import java.util.UUID;
import network.quant.OverledgerContext;
import network.quant.api.Client;
import network.quant.essential.dto.OverledgerTransactionRequest;
import network.quant.essential.dto.OverledgerTransactionResponse;
import network.quant.exception.ClientResponseException;
import org.reactivestreams.Publisher;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public final class OverledgerClient<T extends OverledgerTransactionRequest, S extends OverledgerTransactionResponse>
implements Client<T, S> {
    private static Client I;
    private static final String BEARER = "Bearer";
    private WebClient webClient = WebClient.builder().defaultHeader("Authorization", new String[]{String.format("%s %s:%s", "Bearer", OverledgerContext.MAPP_ID, OverledgerContext.BPI_KEY)}).build();

    private OverledgerClient() {
    }

    private Mono<ClientResponseException> getClientResponse(ClientResponse clientResponse) {
        return clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new);
    }

    public S postTransaction(T ovlTransaction, Class<T> requestClass, Class<S> responseClass) {
        return (S)((OverledgerTransactionResponse)((WebClient.RequestBodySpec)this.webClient.post().uri(OverledgerContext.WRITE_TRANSACTIONS, new Object[0])).contentType(MediaType.APPLICATION_JSON_UTF8).body((Publisher)Mono.just(ovlTransaction), requestClass).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block());
    }

    public S getTransaction(UUID overledgerTransactionID, Class<S> responseClass) {
        return (S)((OverledgerTransactionResponse)this.webClient.get().uri(OverledgerContext.READ_TRANSACTIONS_BY_TRANSACTION_ID, new Object[]{overledgerTransactionID}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block());
    }

    public List<S> getTransactions(String mappId, Class<S> responseClass) {
        return (List)this.webClient.get().uri(OverledgerContext.READ_TRANSACTIONS_BY_MAPP_ID, new Object[]{mappId}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToFlux(responseClass).collectList().block();
    }

    public S getTransaction(String dlt, String transactionHash, Class<S> responseClass) {
        return (S)((OverledgerTransactionResponse)this.webClient.get().uri(OverledgerContext.READ_TRANSACTIONS_BY_TRANSACTION_HASH, new Object[]{dlt, transactionHash}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block());
    }

    static Client getInstance() {
        if (null == I) {
            I = new OverledgerClient();
        }
        return I;
    }
}

