/*
 * Decompiled with CFR 0.152.
 */
package network.quant.essential.util;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import network.quant.api.ENCRYPT_TYPE;
import network.quant.api.Encryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaEncryptor
implements Encryptor {
    private static final Logger log = LoggerFactory.getLogger(RsaEncryptor.class);
    private static final int KEY_LENGTH = 1024;
    private static final String ALGORITHM = "RSA";
    private static final String ALGORITHM_METHOD_PADDING = "RSA/ECB/PKCS1Padding";
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public RsaEncryptor() {
        this.generateKey();
    }

    public RsaEncryptor(String privateKey, String publicKey) {
        this.getPrivateKey(privateKey);
        this.getPublicKey(publicKey);
    }

    private void generateKey() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.publicKey = keyPair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Unable to generate key", (Throwable)e);
        }
    }

    private void getPrivateKey(String privateKey) {
        if (null == privateKey) {
            return;
        }
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey.getBytes()));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            this.privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (Exception e) {
            log.error("Unable to generate private key", (Throwable)e);
        }
    }

    private void getPublicKey(String publicKey) {
        if (null == publicKey) {
            return;
        }
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey.getBytes()));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            this.publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception e) {
            log.error("Unable to generate public key", (Throwable)e);
        }
    }

    private byte[] process(byte[] bytes, int mode, Key key) {
        byte[] result;
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_METHOD_PADDING);
            cipher.init(mode, key);
            result = cipher.doFinal(bytes);
        }
        catch (Exception e) {
            log.error("Unable to process target", (Throwable)e);
            result = null;
        }
        return result;
    }

    public String getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (null != this.publicKey) {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            X509EncodedKeySpec x509EncodedKeySpec = keyFactory.getKeySpec(this.publicKey, X509EncodedKeySpec.class);
            return Base64.getEncoder().encodeToString(x509EncodedKeySpec.getEncoded());
        }
        return null;
    }

    public String getPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (null != this.privateKey) {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = keyFactory.getKeySpec(this.privateKey, PKCS8EncodedKeySpec.class);
            return Base64.getEncoder().encodeToString(pkcs8EncodedKeySpec.getEncoded());
        }
        return null;
    }

    public ENCRYPT_TYPE getType() {
        return ENCRYPT_TYPE.RSA;
    }

    public byte[] encrypt(byte[] bytes) {
        if (null == this.publicKey) {
            return null;
        }
        return this.process(bytes, 1, this.publicKey);
    }

    public byte[] decrypt(byte[] bytes) {
        if (null == this.privateKey) {
            return null;
        }
        return this.process(bytes, 2, this.privateKey);
    }
}

