/*
 * Decompiled with CFR 0.152.
 */
package network.quant.essential;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import network.quant.OverledgerContext;
import network.quant.api.Client;
import network.quant.essential.dto.OverledgerTransactionRequest;
import network.quant.essential.dto.OverledgerTransactionResponse;
import network.quant.exception.ClientResponseException;
import network.quant.exception.RedirectException;
import network.quant.util.Address;
import network.quant.util.BalanceRequest;
import network.quant.util.BalanceResponse;
import network.quant.util.Block;
import network.quant.util.Page;
import network.quant.util.PagedResult;
import network.quant.util.Transaction;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public final class OverledgerClient<T extends OverledgerTransactionRequest, S extends OverledgerTransactionResponse>
implements Client<T, S> {
    private static final Logger log = LoggerFactory.getLogger(OverledgerClient.class);
    private static Client I;
    private static final String BEARER = "Bearer";
    private static final String HEADER_LOCATION = "Location";
    private WebClient webClient = WebClient.builder().defaultHeader("Authorization", new String[]{String.format("%s %s:%s", "Bearer", OverledgerContext.MAPP_ID, OverledgerContext.BPI_KEY)}).build();

    private OverledgerClient() {
    }

    private Mono<ClientResponseException> getClientResponse(ClientResponse clientResponse) {
        return clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new);
    }

    public S postTransaction(T ovlTransaction, Class<T> requestClass, Class<S> responseClass) {
        try {
            return (S)((OverledgerTransactionResponse)((WebClient.RequestBodySpec)this.webClient.post().uri(OverledgerContext.WRITE_TRANSACTIONS, new Object[0])).contentType(MediaType.APPLICATION_JSON_UTF8).body((Publisher)Mono.just(ovlTransaction), requestClass).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(responseClass).block());
        }
        catch (RedirectException e) {
            return (S)((OverledgerTransactionResponse)((WebClient.RequestBodySpec)this.webClient.post().uri(e.getUrl(), new Object[0])).contentType(MediaType.APPLICATION_JSON_UTF8).body((Publisher)Mono.just(ovlTransaction), requestClass).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block());
        }
    }

    public S getTransaction(UUID overledgerTransactionID, Class<S> responseClass) {
        try {
            return (S)((OverledgerTransactionResponse)this.webClient.get().uri(OverledgerContext.READ_TRANSACTIONS_BY_TRANSACTION_ID, new Object[]{overledgerTransactionID}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(responseClass).block());
        }
        catch (RedirectException e) {
            return (S)((OverledgerTransactionResponse)this.webClient.get().uri(e.getUrl(), new Object[0]).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block());
        }
    }

    public List<S> getTransactions(String mappId, Class<S> responseClass) {
        try {
            return (List)this.webClient.get().uri(OverledgerContext.READ_TRANSACTIONS_BY_MAPP_ID, new Object[]{mappId}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(String.class).map(s -> {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return (List)objectMapper.readValue(s, (TypeReference)new TypeReference<List>(){});
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }).block();
        }
        catch (RedirectException e) {
            return (List)this.webClient.get().uri(e.getUrl(), new Object[0]).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(String.class).map(s -> {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return (List)objectMapper.readValue(s, new TypeReference<List<S>>(){});
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
            }).block();
        }
    }

    public PagedResult<S> getTransactions(String mappId, Page page, Class<PagedResult<S>> responseClass) {
        try {
            return (PagedResult)this.webClient.get().uri(OverledgerContext.READ_TRANSACTIONS_BY_MAPP_ID_BY_PAGE, new Object[]{mappId, page.getPageNumber(), page.getPageSize()}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(responseClass).block();
        }
        catch (RedirectException e) {
            return (PagedResult)this.webClient.get().uri(e.getUrl(), new Object[0]).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(responseClass).block();
        }
    }

    public S getTransaction(String dlt, String transactionHash, Class<S> responseClass) {
        try {
            return (S)((OverledgerTransactionResponse)this.webClient.get().uri(OverledgerContext.READ_TRANSACTIONS_BY_TRANSACTION_HASH, new Object[]{dlt, transactionHash}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(responseClass).block());
        }
        catch (RedirectException e) {
            return (S)((OverledgerTransactionResponse)this.webClient.get().uri(e.getUrl(), new Object[0]).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block());
        }
    }

    public List<BalanceResponse> postBalances(List<BalanceRequest> balanceRequests) {
        try {
            return (List)((WebClient.RequestBodySpec)this.webClient.post().uri(OverledgerContext.BALANCES_CHECK, new Object[0])).body(BodyInserters.fromObject(balanceRequests)).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(String.class).map(s -> {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return (List)objectMapper.readValue(s, (TypeReference)new TypeReference<List<BalanceResponse>>(){});
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
            }).block();
        }
        catch (RedirectException e) {
            return (List)((WebClient.RequestBodySpec)this.webClient.post().uri(e.getUrl(), new Object[0])).body(BodyInserters.fromObject(balanceRequests)).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(String.class).map(s -> {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return (List)objectMapper.readValue(s, (TypeReference)new TypeReference<List<BalanceResponse>>(){});
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
            }).block();
        }
    }

    public Transaction searchTransaction(String transactionHash, Class<Transaction> responseClass) {
        try {
            return (Transaction)this.webClient.get().uri(OverledgerContext.SEARCH_TRANSACTIONS, new Object[]{transactionHash}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(responseClass).block();
        }
        catch (RedirectException e) {
            return (Transaction)this.webClient.get().uri(e.getUrl(), new Object[0]).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block();
        }
    }

    public Address searchAddress(String address, Class<Address> responseClass) {
        try {
            return (Address)this.webClient.get().uri(OverledgerContext.SEARCH_ADDRESSES, new Object[]{address}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(responseClass).block();
        }
        catch (RedirectException e) {
            return (Address)this.webClient.get().uri(e.getUrl(), new Object[0]).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block();
        }
    }

    public Block searchBlock(String dlt, String blockhash, Class<Block> responseClass) {
        try {
            return (Block)this.webClient.get().uri(OverledgerContext.SEARCH_CHAIN_BLOCKS, new Object[]{dlt, blockhash}).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header(HEADER_LOCATION).get(0)))).bodyToMono(responseClass).block();
        }
        catch (RedirectException e) {
            return (Block)this.webClient.get().uri(e.getUrl(), new Object[0]).retrieve().onStatus(HttpStatus::is4xxClientError, this::getClientResponse).onStatus(HttpStatus::is5xxServerError, this::getClientResponse).bodyToMono(responseClass).block();
        }
    }

    static Client getInstance() {
        if (null == I) {
            I = new OverledgerClient();
        }
        return I;
    }
}

