/*
 * Decompiled with CFR 0.152.
 */
package network.quant.essential;

import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import network.quant.api.Account;
import network.quant.api.Client;
import network.quant.api.DltTransaction;
import network.quant.api.DltTransactionRequest;
import network.quant.api.NETWORK;
import network.quant.api.OverledgerSDK;
import network.quant.api.OverledgerTransaction;
import network.quant.essential.AccountManager;
import network.quant.essential.OverledgerClient;
import network.quant.essential.dto.DltBytesTransactionRequest;
import network.quant.essential.dto.DltStreamTransactionRequest;
import network.quant.essential.dto.OverledgerTransactionPageResult;
import network.quant.essential.dto.OverledgerTransactionRequest;
import network.quant.essential.dto.OverledgerTransactionResponse;
import network.quant.essential.exception.DltNotSupportedException;
import network.quant.essential.exception.EmptyAccountException;
import network.quant.essential.exception.EmptyDltException;
import network.quant.essential.exception.IllegalKeyException;
import network.quant.util.Address;
import network.quant.util.BalanceRequest;
import network.quant.util.BalanceResponse;
import network.quant.util.Block;
import network.quant.util.CommonUtil;
import network.quant.util.Page;
import network.quant.util.PagedResult;
import network.quant.util.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultOverledgerSDK
implements OverledgerSDK {
    private static final Logger log = LoggerFactory.getLogger(DefaultOverledgerSDK.class);
    private NETWORK network;
    private AccountManager accountManager;
    private Client client;

    private DefaultOverledgerSDK(NETWORK network) {
        this(network, AccountManager.newInstance(), OverledgerClient.getInstance());
    }

    private DefaultOverledgerSDK(NETWORK network, AccountManager accountManager, Client client) {
        this.initial(network);
        this.accountManager = accountManager;
        this.client = client;
    }

    private void throwCauseException(Exception e) throws Exception {
        Throwable exception = e;
        while (null != exception.getCause()) {
            exception = e.getCause();
        }
        throw exception;
    }

    private boolean verifySupportAllDLTs(OverledgerTransaction ovlTransaction) {
        return ovlTransaction.getDltData().stream().anyMatch(dltTransaction -> Optional.ofNullable(this.accountManager.getAccount(dltTransaction.getDlt())).isPresent());
    }

    private void verifyOverledgerTransaction(OverledgerTransaction ovlTransaction) throws EmptyDltException, DltNotSupportedException {
        if (null == ovlTransaction) {
            throw new NullPointerException();
        }
        if (null == ovlTransaction.getDltData()) {
            throw new EmptyDltException();
        }
        if (!this.verifySupportAllDLTs(ovlTransaction)) {
            throw new DltNotSupportedException();
        }
    }

    public NETWORK getNetwork() {
        return this.network;
    }

    public void initial(NETWORK network) {
        this.network = network;
    }

    public void addAccount(String dlt, Account account) {
        try {
            this.accountManager.registerAccount(dlt, account.withNetwork(this.network));
        }
        catch (EmptyAccountException | IllegalKeyException e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public OverledgerTransaction writeTransaction(OverledgerTransaction ovlTransaction) throws Exception {
        this.verifyOverledgerTransaction(ovlTransaction);
        OverledgerTransactionResponse overledgerTransaction = null;
        try {
            ovlTransaction.getDltData().stream().map(dltTransaction -> (DltTransactionRequest)dltTransaction).map(dltTransactionRequest -> {
                if (dltTransactionRequest instanceof DltStreamTransactionRequest) {
                    this.accountManager.getAccount(dltTransactionRequest.getDlt()).sign(dltTransactionRequest.getFromAddress(), dltTransactionRequest.getToAddress(), ((DltStreamTransactionRequest)dltTransactionRequest).getInputStream(), (DltTransaction)dltTransactionRequest);
                } else if (dltTransactionRequest instanceof DltBytesTransactionRequest) {
                    this.accountManager.getAccount(dltTransactionRequest.getDlt()).sign(dltTransactionRequest.getFromAddress(), dltTransactionRequest.getToAddress(), ((DltBytesTransactionRequest)dltTransactionRequest).getBytes(), (DltTransaction)dltTransactionRequest);
                } else {
                    this.accountManager.getAccount(dltTransactionRequest.getDlt()).sign(dltTransactionRequest.getFromAddress(), dltTransactionRequest.getToAddress(), dltTransactionRequest.getMessage(), (DltTransaction)dltTransactionRequest);
                }
                return dltTransactionRequest;
            }).collect(Collectors.toList());
            overledgerTransaction = (OverledgerTransactionResponse)this.client.postTransaction((Object)ovlTransaction, OverledgerTransactionRequest.class, OverledgerTransactionResponse.class);
        }
        catch (Exception e) {
            this.throwCauseException(e);
        }
        return overledgerTransaction;
    }

    public OverledgerTransaction readTransaction(UUID overledgerTransactionID) throws Exception {
        OverledgerTransactionResponse overledgerTransaction = null;
        try {
            overledgerTransaction = (OverledgerTransactionResponse)this.client.getTransaction(overledgerTransactionID, OverledgerTransactionResponse.class);
        }
        catch (Exception e) {
            this.throwCauseException(e);
        }
        return overledgerTransaction;
    }

    public List<OverledgerTransaction> readTransactions(String mappId) throws Exception {
        List overledgerTransactionList = null;
        try {
            overledgerTransactionList = this.client.getTransactions(mappId, OverledgerTransactionResponse.class);
        }
        catch (Exception e) {
            this.throwCauseException(e);
        }
        return overledgerTransactionList;
    }

    public PagedResult<OverledgerTransaction> readTransactions(String mappId, Page page) throws Exception {
        PagedResult pageResult = null;
        try {
            pageResult = this.client.getTransactions(mappId, page, OverledgerTransactionPageResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.throwCauseException(e);
        }
        return pageResult;
    }

    public OverledgerTransaction readTransaction(String dlt, String transactionHash) throws Exception {
        OverledgerTransactionResponse overledgerTransaction = null;
        try {
            overledgerTransaction = (OverledgerTransactionResponse)this.client.getTransaction(dlt, transactionHash, OverledgerTransactionResponse.class);
        }
        catch (Exception e) {
            this.throwCauseException(e);
        }
        return overledgerTransaction;
    }

    public Transaction searchTransaction(String transactionHash, Class<Transaction> responseClass) {
        return this.client.searchTransaction(transactionHash, responseClass);
    }

    public Address searchAddress(String address, Class<Address> responseClass) {
        return this.client.searchAddress(address, responseClass);
    }

    public Block searchBlock(String dlt, String blockhash, Class<Block> responseClass) {
        return this.client.searchBlock(dlt, blockhash, responseClass);
    }

    public List<BalanceResponse> searchBalance(List<BalanceRequest> balanceRequests) {
        return this.client.postBalances(balanceRequests);
    }

    public OverledgerTransaction writeTransaction(OverledgerTransaction ovlTransaction, byte[] data) throws Exception {
        this.verifyOverledgerTransaction(ovlTransaction);
        OverledgerTransactionResponse overledgerTransaction = null;
        try {
            ovlTransaction.getDltData().stream().map(dltTransaction -> (DltTransactionRequest)dltTransaction).map(dltTransactionRequest -> {
                this.accountManager.getAccount(dltTransactionRequest.getDlt()).sign(dltTransactionRequest.getFromAddress(), dltTransactionRequest.getToAddress(), data, (DltTransaction)dltTransactionRequest);
                return dltTransactionRequest;
            }).collect(Collectors.toList());
            overledgerTransaction = (OverledgerTransactionResponse)this.client.postTransaction((Object)ovlTransaction, OverledgerTransactionRequest.class, OverledgerTransactionResponse.class);
        }
        catch (Exception e) {
            this.throwCauseException(e);
        }
        return overledgerTransaction;
    }

    public OverledgerTransaction writeTransaction(OverledgerTransaction ovlTransaction, InputStream inputStream) throws Exception {
        return this.writeTransaction(ovlTransaction, CommonUtil.getStream((InputStream)inputStream));
    }

    public static DefaultOverledgerSDK newInstance(NETWORK network) {
        return new DefaultOverledgerSDK(network);
    }

    public static DefaultOverledgerSDK newInstance(NETWORK network, AccountManager accountManager, Client client) {
        return new DefaultOverledgerSDK(network, accountManager, client);
    }
}

