/*
 * Decompiled with CFR 0.152.
 */
package network.quant.essential;

import java.util.HashMap;
import java.util.Map;
import network.quant.api.Account;
import network.quant.essential.exception.EmptyAccountException;
import network.quant.essential.exception.IllegalKeyException;

class AccountManager {
    private Map<String, Account> accountMap;

    private AccountManager() {
    }

    void registerAccount(String dlt, Account account) throws IllegalKeyException, EmptyAccountException {
        if (null == dlt) {
            throw new IllegalKeyException();
        }
        if (null == account) {
            throw new EmptyAccountException();
        }
        if (null == this.accountMap) {
            this.accountMap = new HashMap<String, Account>();
        }
        this.accountMap.put(dlt, account);
    }

    Account getAccount(String dlt) {
        if (null != this.accountMap) {
            return this.accountMap.get(dlt);
        }
        return null;
    }

    static AccountManager newInstance() {
        return new AccountManager();
    }
}

