/*
 * Decompiled with CFR 0.152.
 */
package network.quant.bitcoin;

import java.math.BigInteger;
import network.quant.api.FEE_POLICY;
import network.quant.bitcoin.BitcoinFeesRecommended;
import network.quant.bitcoin.FeePolicy;
import network.quant.bitcoin.exception.BitcoinFeesRequestFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClient;

public class BitcoinFees
implements FeePolicy {
    private static final Logger log = LoggerFactory.getLogger(BitcoinFees.class);
    private static final String FEE_URL = "https://bitcoinfees.earn.com/api/v1/fees/recommended";
    private static final long REFRESH_TIME = 300000L;
    private static BitcoinFees I;
    private long lastUpdate = -1L;
    private WebClient webClient = WebClient.create((String)"https://bitcoinfees.earn.com/api/v1/fees/recommended");
    private BigInteger priority = new BigInteger("6");
    private BigInteger normal = new BigInteger("4");
    private BigInteger economy = new BigInteger("2");

    private BitcoinFees() {
    }

    private void getFees() {
        BitcoinFeesRecommended recommended = (BitcoinFeesRecommended)this.webClient.get().retrieve().onStatus(HttpStatus::is4xxClientError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(BitcoinFeesRequestFailedException::new)).onStatus(HttpStatus::is5xxServerError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(BitcoinFeesRequestFailedException::new)).bodyToMono(BitcoinFeesRecommended.class).block();
        if (null != recommended) {
            this.priority = BigInteger.valueOf(recommended.getFastestFee());
            this.normal = BigInteger.valueOf(recommended.getHalfHourFee());
            this.economy = BigInteger.valueOf(recommended.getHourFee());
        }
    }

    private void updateFees() {
        long now = System.currentTimeMillis();
        if (this.lastUpdate < 0L || now - this.lastUpdate > 300000L) {
            this.getFees();
            this.lastUpdate = now;
        }
    }

    @Override
    public BigInteger calculate(FEE_POLICY fee_policy, int inputs, int outputs) {
        try {
            this.updateFees();
        }
        catch (Exception e) {
            log.warn("Unable to connect to bitcoinfees service", (Throwable)e);
        }
        int bytes = inputs * 180 + outputs * 34 + 10;
        switch (fee_policy) {
            case PRIORITY: {
                return BigInteger.valueOf(bytes + inputs).multiply(this.priority);
            }
            case ECONOMY: {
                return BigInteger.valueOf(bytes + inputs * (0L == System.currentTimeMillis() % 2L ? -1 : 1)).multiply(this.economy);
            }
        }
        return BigInteger.valueOf(bytes - inputs).multiply(this.normal);
    }

    static BitcoinFees getInstance() {
        if (null == I) {
            I = new BitcoinFees();
        }
        return I;
    }
}

