/*
 * Decompiled with CFR 0.152.
 */
package network.quant.bitcoin;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import network.quant.api.Compressor;
import network.quant.api.DATA_TYPE;
import network.quant.api.ENCRYPT_TYPE;
import network.quant.api.Encryptor;
import network.quant.api.NETWORK;
import network.quant.bitcoin.BitcoinHeader;
import network.quant.bitcoin.BitcoinUtils;
import network.quant.bitcoin.exception.BitcoinDataNotMatchingLengthException;
import network.quant.bitcoin.exception.BitcoinInvalidAddressException;
import network.quant.exception.AddressChecksumNotMatchException;
import network.quant.exception.DataNotFoundException;
import network.quant.exception.DataOverSizeException;
import network.quant.exception.NetworkNotMatchException;
import network.quant.exception.UnknownDataException;
import network.quant.util.CommonUtil;

public class BitcoinData {
    private static final int MAX_SIZE = 50000;
    private NETWORK network;
    private Encryptor encryptor;
    private Compressor compressor;
    private List<String> addressList;
    private byte[] data;
    private DATA_TYPE type;

    public BitcoinData(NETWORK network, List<String> addressList, Encryptor encryptor, Compressor compressor) throws UnknownDataException, AddressChecksumNotMatchException, NetworkNotMatchException, DataNotFoundException, BitcoinDataNotMatchingLengthException, BitcoinInvalidAddressException {
        this.network = network;
        this.addressList = addressList;
        this.encryptor = encryptor;
        this.compressor = compressor;
        this.setData();
        if (null != this.compressor) {
            this.data = this.compressor.decompress(this.data);
        }
        if (null != this.encryptor) {
            this.data = this.encryptor.decrypt(this.data);
        }
    }

    public BitcoinData(NETWORK network, byte[] data, DATA_TYPE type, Encryptor encryptor, Compressor compressor) throws DataOverSizeException {
        if (data.length > 50000) {
            throw new DataOverSizeException();
        }
        this.network = network;
        this.data = data;
        this.type = type;
        this.encryptor = encryptor;
        this.compressor = compressor;
        if (null != this.encryptor) {
            this.data = this.encryptor.encrypt(this.data);
        }
        if (null != this.compressor) {
            this.data = this.compressor.compress(this.data);
        }
        this.setAddressList();
    }

    public BitcoinData(NETWORK network, InputStream stream, DATA_TYPE type, Encryptor encryptor, Compressor compressor) throws DataOverSizeException, IOException {
        if (stream.available() > 50000) {
            throw new DataOverSizeException();
        }
        this.network = network;
        this.data = CommonUtil.getStream((InputStream)stream);
        this.type = type;
        this.encryptor = encryptor;
        this.compressor = compressor;
        if (null != this.encryptor) {
            this.data = this.encryptor.encrypt(this.data);
        }
        if (null != this.compressor) {
            this.data = this.compressor.compress(this.data);
        }
        this.setAddressList();
    }

    private void setData() throws UnknownDataException, AddressChecksumNotMatchException, NetworkNotMatchException, DataNotFoundException, BitcoinDataNotMatchingLengthException, BitcoinInvalidAddressException {
        if (this.addressList.size() < 2) {
            throw new DataNotFoundException();
        }
        BitcoinHeader bitcoinHeader = new BitcoinHeader(this.network, this.addressList.remove(0));
        this.data = BitcoinUtils.getData(this.addressList, Math.toIntExact(bitcoinHeader.getLength()));
    }

    private void setAddressList() {
        BitcoinHeader bitcoinHeader = new BitcoinHeader(this.network, this.type, null == this.encryptor ? ENCRYPT_TYPE.NONE : this.encryptor.getType(), null != this.compressor, this.data.length);
        this.addressList = BitcoinUtils.getAddress(this.network, this.data);
        this.addressList.add(0, bitcoinHeader.getAddress());
    }

    public List<String> getAddressList() {
        return this.addressList;
    }

    public byte[] getData() {
        return this.data;
    }
}

