/*
 * Decompiled with CFR 0.152.
 */
package network.quant.bitcoin.experimental;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import network.quant.OverledgerContext;
import network.quant.bitcoin.BitcoinAccount;
import network.quant.bitcoin.experimental.Dto.FaucetResponseDto;
import network.quant.exception.ClientResponseException;
import network.quant.exception.RedirectException;
import org.bitcoinj.params.RegTestParams;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class BitcoinFaucetHelper {
    private static BitcoinFaucetHelper I;
    private static final BigDecimal BTC_IN_SATOSHI;
    private static final int ONE_BTC = 1;
    private static final String BEARER = "Bearer";
    private WebClient webClient = WebClient.builder().defaultHeader("Authorization", new String[]{String.format("%s %s:%s", "Bearer", OverledgerContext.MAPP_ID, OverledgerContext.BPI_KEY)}).build();
    private String url;

    private BitcoinFaucetHelper() {
    }

    private void addUtxo(BitcoinAccount bitcoinAccount, String result) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            FaucetResponseDto faucetResponseDto = (FaucetResponseDto)objectMapper.readValue(result, FaucetResponseDto.class);
            bitcoinAccount.addUtxo(faucetResponseDto.getTxnHash(), faucetResponseDto.getVout(), faucetResponseDto.amount.abs().longValue(), 1, faucetResponseDto.getAddress());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void redirectPost(BitcoinAccount bitcoinAccount, String uri) {
        ((WebClient.RequestBodySpec)this.webClient.post().uri(uri, new Object[0])).contentType(MediaType.APPLICATION_JSON_UTF8).retrieve().onStatus(HttpStatus::is4xxClientError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).onStatus(HttpStatus::is5xxServerError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).bodyToMono(String.class).doOnSuccess(result -> this.addUtxo(bitcoinAccount, (String)result)).doOnError(RuntimeException::new).block();
    }

    public void fundAccount(BitcoinAccount bitcoinAccount) {
        if (null != bitcoinAccount && RegTestParams.get().equals((Object)bitcoinAccount.getNetworkParam())) {
            try {
                ((WebClient.RequestBodySpec)this.webClient.post().uri(this.url, new Object[]{bitcoinAccount.getKey().toAddress(bitcoinAccount.getNetworkParameters()).toBase58(), BTC_IN_SATOSHI.multiply(BigDecimal.ONE)})).contentType(MediaType.APPLICATION_JSON_UTF8).retrieve().onStatus(HttpStatus::is4xxClientError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).onStatus(HttpStatus::is5xxServerError, clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class).map(ByteArrayResource::getByteArray).map(String::new).map(ClientResponseException::new)).onStatus(HttpStatus::is3xxRedirection, clientResponse -> Mono.error((Throwable)new RedirectException((String)clientResponse.headers().header("Location").get(0)))).bodyToMono(String.class).doOnSuccess(result -> this.addUtxo(bitcoinAccount, (String)result)).block();
            }
            catch (RedirectException e) {
                this.redirectPost(bitcoinAccount, e.getUrl());
            }
        }
    }

    public static BitcoinFaucetHelper getInstance(String url) {
        if (null == I) {
            I = new BitcoinFaucetHelper();
        }
        BitcoinFaucetHelper.I.url = url;
        return I;
    }

    static {
        BTC_IN_SATOSHI = BigDecimal.valueOf(100000000L);
    }
}

