/*
 * Decompiled with CFR 0.152.
 */
package network.quant.bitcoin;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import network.quant.api.NETWORK;
import network.quant.bitcoin.exception.BitcoinDataNotMatchingLengthException;
import network.quant.bitcoin.exception.BitcoinInvalidAddressException;
import org.bitcoinj.core.Base58;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinUtils {
    private static final Logger log = LoggerFactory.getLogger(BitcoinUtils.class);
    static final int NETWORK_SIZE = 1;
    static final int PAYLOAD_SIZE = 20;
    private static final int ADDRESS_SIZE = 25;
    static final int CHECKSUM_SIZE = 4;
    static final byte ZERO = 0;
    private static final String HASH_ALG = "SHA-256";
    private static MessageDigest DIGEST;

    private static byte[] getBytes(int from, int length, byte[] bytes) {
        byte[] result = new byte[length];
        int byteReadingLength = from + length;
        if (byteReadingLength > bytes.length) {
            Arrays.fill(result, (byte)0);
            int remainLength = byteReadingLength - bytes.length;
            int readingLength = length - remainLength;
            System.arraycopy(bytes, from, result, 0, readingLength);
        } else {
            System.arraycopy(bytes, from, result, 0, length);
        }
        return result;
    }

    static byte[] sha256(byte[] plain) {
        if (null == DIGEST) {
            try {
                DIGEST = MessageDigest.getInstance(HASH_ALG);
            }
            catch (Exception e) {
                log.error(String.format("%s#sha256(): failed", BitcoinUtils.class.getSimpleName()), (Throwable)e);
            }
        }
        if (null != DIGEST) {
            return DIGEST.digest(plain);
        }
        return null;
    }

    static byte[] createAddrBytes(NETWORK network, byte[] bytes) {
        byte[] result = null;
        if (null != bytes) {
            result = new byte[25];
            System.arraycopy(new byte[]{(byte)network.getAddressType()}, 0, result, 0, 1);
            System.arraycopy(bytes, 0, result, 1, 20);
            byte[] hash = BitcoinUtils.sha256(BitcoinUtils.sha256(ByteBuffer.allocate(21).put((byte)network.getAddressType()).put(bytes).array()));
            if (null == hash) {
                return null;
            }
            System.arraycopy(hash, 0, result, 21, 4);
        }
        return result;
    }

    static List<String> getAddress(NETWORK network, byte[] bytes) {
        ArrayList<String> addrList = new ArrayList<String>();
        for (int i = 0; i < bytes.length; i += 20) {
            byte[] result = BitcoinUtils.createAddrBytes(network, BitcoinUtils.getBytes(i, 20, bytes));
            if (null == result) continue;
            addrList.add(Base58.encode((byte[])result));
        }
        return addrList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] getData(List<String> addressList, int length) throws BitcoinDataNotMatchingLengthException, BitcoinInvalidAddressException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        for (int i = 0; i < addressList.size(); ++i) {
            byte[] address = Base58.decode((String)addressList.get(i));
            ByteBuffer network = ByteBuffer.allocate(1);
            network.put(address, 0, 1);
            ByteBuffer data = ByteBuffer.allocate(20);
            data.put(address, 1, 20);
            ByteBuffer checksum = ByteBuffer.allocate(4);
            checksum.put(address, 21, 4);
            ByteBuffer calculatedHash = ByteBuffer.allocate(4);
            byte[] hash = BitcoinUtils.sha256(BitcoinUtils.sha256(ByteBuffer.allocate(21).put(network.array()).put(data.array()).array()));
            if (null == hash) throw new BitcoinInvalidAddressException(addressList.get(i));
            calculatedHash.put(hash, 0, 4);
            if (Arrays.compare(calculatedHash.array(), checksum.array()) != 0) throw new BitcoinInvalidAddressException(addressList.get(i));
            int location = i * 20;
            if (location + 20 > length) {
                byteBuffer.put(data.array(), 0, length - location);
                return byteBuffer.array();
            }
            byteBuffer.put(data.array(), 0, 20);
        }
        throw new BitcoinDataNotMatchingLengthException();
    }
}

