/*
 * Decompiled with CFR 0.152.
 */
package network.quant.bitcoin;

import java.nio.ByteBuffer;
import java.util.Arrays;
import network.quant.api.DATA_TYPE;
import network.quant.api.ENCRYPT_TYPE;
import network.quant.api.NETWORK;
import network.quant.bitcoin.BitcoinUtils;
import network.quant.exception.AddressChecksumNotMatchException;
import network.quant.exception.NetworkNotMatchException;
import network.quant.exception.UnknownDataException;
import org.bitcoinj.core.Base58;

class BitcoinHeader {
    private static final byte[] CODE = "QNT".getBytes();
    private static ByteBuffer LONG_BUF = ByteBuffer.allocate(8);
    private DATA_TYPE type;
    private ENCRYPT_TYPE encryption;
    private Boolean compressed;
    private long length;
    private String address;
    private NETWORK network;

    BitcoinHeader(NETWORK network, DATA_TYPE type, ENCRYPT_TYPE encryption, Boolean compressed, long length) {
        this.network = network;
        this.type = type;
        this.encryption = encryption;
        this.compressed = compressed;
        this.length = length;
        this.parse();
    }

    BitcoinHeader(NETWORK network, String address) throws NetworkNotMatchException, AddressChecksumNotMatchException, UnknownDataException {
        this.network = network;
        this.address = address;
        this.format();
    }

    private void parse() {
        byte[] result = new byte[20];
        int from = 0;
        System.arraycopy(CODE, 0, result, from, CODE.length);
        byte[] type = new byte[4];
        byte[] typeRaw = this.type.name().getBytes();
        Arrays.fill(type, (byte)0);
        System.arraycopy(typeRaw, 0, type, 0, typeRaw.length);
        System.arraycopy(type, 0, result, from += CODE.length, type.length);
        byte[] encryption = new byte[4];
        byte[] encryptionRaw = this.encryption.name().getBytes();
        Arrays.fill(encryption, (byte)0);
        System.arraycopy(encryptionRaw, 0, encryption, 0, encryptionRaw.length);
        System.arraycopy(encryption, 0, result, from += type.length, encryption.length);
        from += encryption.length;
        result[from++] = this.compressed != false ? (byte)1 : 0;
        System.arraycopy(LONG_BUF.putLong(0, this.length).array(), 0, result, from, 8);
        byte[] addressByte = BitcoinUtils.createAddrBytes(this.network, result);
        if (null != addressByte) {
            this.address = Base58.encode((byte[])addressByte);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void format() throws NetworkNotMatchException, AddressChecksumNotMatchException, UnknownDataException {
        byte[] bytes = Base58.decode((String)this.address);
        ByteBuffer dataBuffer = ByteBuffer.allocate(20);
        dataBuffer.put(bytes, 1, 20);
        ByteBuffer checkSumBuffer = ByteBuffer.allocate(4);
        checkSumBuffer.put(bytes, 21, 4);
        if (bytes[0] != this.network.getAddressType()) throw new NetworkNotMatchException();
        byte[] data = dataBuffer.array();
        ByteBuffer hashBuffer = ByteBuffer.allocate(4);
        byte[] hash = BitcoinUtils.sha256(BitcoinUtils.sha256(ByteBuffer.allocate(21).put((byte)this.network.getAddressType()).put(data).array()));
        if (null == hash) {
            return;
        }
        hashBuffer.put(hash, 0, 4);
        if (!Arrays.equals(hashBuffer.array(), checkSumBuffer.array())) throw new AddressChecksumNotMatchException();
        ByteBuffer codeBuffer = ByteBuffer.allocate(CODE.length);
        codeBuffer.put(data, 0, CODE.length);
        if (!Arrays.equals(codeBuffer.array(), CODE)) {
            throw new UnknownDataException();
        }
        ByteBuffer typeBuffer = ByteBuffer.allocate(4);
        typeBuffer.put(data, CODE.length, 4);
        this.type = DATA_TYPE.valueOf((String)new String(typeBuffer.array()));
        ByteBuffer encryptionBuffer = ByteBuffer.allocate(4);
        encryptionBuffer.put(data, CODE.length + 4, 4);
        this.encryption = ENCRYPT_TYPE.valueOf((String)new String(encryptionBuffer.array()));
        this.compressed = 0 != data[CODE.length + 8];
        ByteBuffer lengthBuffer = ByteBuffer.allocate(8);
        lengthBuffer.put(data, CODE.length + 9, 8);
        lengthBuffer.flip();
        this.length = lengthBuffer.getLong();
    }

    public DATA_TYPE getType() {
        return this.type;
    }

    public ENCRYPT_TYPE getEncryption() {
        return this.encryption;
    }

    public Boolean getCompressed() {
        return this.compressed;
    }

    public long getLength() {
        return this.length;
    }

    public String getAddress() {
        return this.address;
    }
}

