/*
 * Decompiled with CFR 0.152.
 */
package network.quant.bitcoin;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import network.quant.api.Account;
import network.quant.api.Compressor;
import network.quant.api.DATA_TYPE;
import network.quant.api.DltTransaction;
import network.quant.api.DltTransactionRequest;
import network.quant.api.Encryptor;
import network.quant.api.FEE_POLICY;
import network.quant.api.NETWORK;
import network.quant.bitcoin.BitcoinData;
import network.quant.bitcoin.BitcoinFees;
import network.quant.exception.DataOverSizeException;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.core.Utils;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.script.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinAccount
implements Account {
    private static final Logger log = LoggerFactory.getLogger(BitcoinAccount.class);
    private static BitcoinAccount I;
    private static final int MAIN_ADDR = 0;
    private static final int TEST_ADDR = 111;
    private static final int NAME_ADDR = 52;
    private static final String SCRIPT_OP_DUP_OP_HASH160_PUBKEY_OP_EQUALVERIFY_OP_CHECKSIG = "76a914%s88ac";
    private NetworkParameters networkParameters;
    private ECKey key;
    private List<UTXO> utxoList;
    private Encryptor encryptor;
    private Compressor compressor;

    private BitcoinAccount(NetworkParameters networkParameters) {
        this(networkParameters, new ECKey());
    }

    private BitcoinAccount(NetworkParameters networkParameters, BigInteger privateKey) {
        this(networkParameters, ECKey.fromPrivate((BigInteger)privateKey));
    }

    private BitcoinAccount(NetworkParameters networkParameters, byte[] privateKey) {
        this(networkParameters, ECKey.fromPrivate((byte[])privateKey));
    }

    private BitcoinAccount(NetworkParameters networkParameters, ECKey privateKey) {
        Context.getOrCreate((NetworkParameters)networkParameters);
        this.networkParameters = networkParameters;
        this.key = privateKey;
    }

    private BitcoinData createBitcoinData(Object data, DATA_TYPE type) throws DataOverSizeException, IOException {
        switch (this.networkParameters.getAddressHeader()) {
            case 111: {
                if (data instanceof InputStream) {
                    return new BitcoinData(NETWORK.TEST, (InputStream)data, type, this.encryptor, this.compressor);
                }
                return new BitcoinData(NETWORK.TEST, (byte[])data, type, this.encryptor, this.compressor);
            }
        }
        if (data instanceof InputStream) {
            return new BitcoinData(NETWORK.MAIN, (InputStream)data, type, this.encryptor, this.compressor);
        }
        return new BitcoinData(NETWORK.MAIN, (byte[])data, type, this.encryptor, this.compressor);
    }

    private void sign(String fromAddress, String toAddress, Object message, DATA_TYPE type, DltTransactionRequest dltTransaction) {
        Transaction transaction = new Transaction(this.networkParameters);
        Coin totalPayout = Coin.valueOf((long)dltTransaction.getAmount().longValue());
        int outputNumber = 2;
        if (null != dltTransaction.getMessage() && !dltTransaction.getMessage().isEmpty()) {
            try {
                BitcoinData bitcoinData = this.createBitcoinData(message, type);
                for (String address : bitcoinData.getAddressList()) {
                    transaction.addOutput(Transaction.MIN_NONDUST_OUTPUT, Address.fromBase58((NetworkParameters)this.networkParameters, (String)address));
                    totalPayout = totalPayout.add(Transaction.MIN_NONDUST_OUTPUT);
                }
                outputNumber += bitcoinData.getAddressList().size();
            }
            catch (DataOverSizeException e) {
                log.error(this.getClass().getSimpleName() + "#signTransaction()", (Throwable)e);
            }
            catch (IOException e) {
                log.error(this.getClass().getSimpleName() + "#signTransaction()", (Throwable)e);
            }
        }
        transaction.addOutput(Coin.valueOf((long)dltTransaction.getAmount().longValue()), Address.fromBase58((NetworkParameters)this.networkParameters, (String)toAddress));
        totalPayout = totalPayout.add(Coin.valueOf((long)(null == dltTransaction.getFee() ? BitcoinFees.getInstance().calculate(FEE_POLICY.NORMAL, 1, outputNumber).longValue() : dltTransaction.getFee().longValue())));
        Coin payout = Coin.valueOf((long)totalPayout.getValue());
        UTXO inputUtxo = this.utxoList.stream().filter(utxo -> utxo.getAddress().equals(fromAddress) && utxo.getValue().isGreaterThan(payout)).findFirst().orElse(null);
        if (null == inputUtxo) {
            return;
        }
        transaction.addOutput(inputUtxo.getValue().subtract(totalPayout), Address.fromBase58((NetworkParameters)this.networkParameters, (String)(null == dltTransaction.getChangeAddress() ? fromAddress : dltTransaction.getChangeAddress())));
        TransactionOutPoint transactionOutPoint = new TransactionOutPoint(this.networkParameters, inputUtxo.getIndex(), inputUtxo.getHash());
        transaction.addSignedInput(transactionOutPoint, inputUtxo.getScript(), this.key, Transaction.SigHash.ALL, true);
        transaction.getConfidence().setSource(TransactionConfidence.Source.SELF);
        transaction.setPurpose(Transaction.Purpose.USER_PAYMENT);
        dltTransaction.setSignedTransaction(DatatypeConverter.printHexBinary((byte[])transaction.bitcoinSerialize()));
    }

    public Account withNetwork(NETWORK network) {
        this.networkParameters = BitcoinAccount.setNetwork(network);
        return this;
    }

    public void setPrivateKey(BigInteger key) {
        if (null != key) {
            this.key = ECKey.fromPrivate((BigInteger)key);
        }
    }

    public BigInteger getPrivateKey() {
        return this.key.getPrivKey();
    }

    public String getPrivateKeyAsWif() {
        return this.key.getPrivateKeyAsWiF(this.networkParameters);
    }

    public NetworkParameters getNetworkParam() {
        return this.networkParameters;
    }

    public void sign(String fromAddress, String toAddress, String message, DltTransaction dltTransaction) {
        if (dltTransaction instanceof DltTransactionRequest) {
            this.sign(fromAddress, toAddress, message.getBytes(), DATA_TYPE.TEXT, (DltTransactionRequest)dltTransaction);
        }
    }

    public void sign(String fromAddress, String toAddress, byte[] message, DltTransaction dltTransaction) {
        if (dltTransaction instanceof DltTransactionRequest) {
            this.sign(fromAddress, toAddress, message, DATA_TYPE.BYTE, (DltTransactionRequest)dltTransaction);
        }
    }

    public void sign(String fromAddress, String toAddress, InputStream stream, DltTransaction dltTransaction) {
        if (dltTransaction instanceof DltTransactionRequest) {
            this.sign(fromAddress, toAddress, stream, DATA_TYPE.BYTE, (DltTransactionRequest)dltTransaction);
        }
    }

    public void addUtxo(String transactionHash, long outpoint, long valueInSatoshi, int blockHeight, String address) {
        if (null == this.utxoList) {
            this.utxoList = new ArrayList<UTXO>();
        }
        byte[] pubKey = Base58.decodeChecked((String)address);
        String pubKeyHex = String.format(SCRIPT_OP_DUP_OP_HASH160_PUBKEY_OP_EQUALVERIFY_OP_CHECKSIG, DatatypeConverter.printHexBinary((byte[])ByteBuffer.allocate(pubKey.length - 1).put(pubKey, 1, pubKey.length - 1).array()).toLowerCase());
        Script script = new Script(Utils.HEX.decode((CharSequence)pubKeyHex));
        this.utxoList.add(new UTXO(Sha256Hash.wrap((String)transactionHash), outpoint, Coin.valueOf((long)valueInSatoshi), blockHeight, false, script, address));
    }

    private static NetworkParameters setNetwork(NETWORK network) {
        MainNetParams networkParameters;
        switch (network) {
            case MAIN: {
                networkParameters = MainNetParams.get();
                break;
            }
            case TEST: {
                networkParameters = RegTestParams.get();
                break;
            }
            case KOVAN: {
                networkParameters = TestNet3Params.get();
                break;
            }
            case RINKEBY: {
                networkParameters = TestNet3Params.get();
                break;
            }
            case ROPSTEN: {
                networkParameters = TestNet3Params.get();
                break;
            }
            default: {
                networkParameters = MainNetParams.get();
            }
        }
        return networkParameters;
    }

    public static Account getInstance(NETWORK network, Encryptor encryptor, Compressor compressor) {
        I = new BitcoinAccount(BitcoinAccount.setNetwork(network));
        I.setEncryptor(encryptor);
        I.setCompressor(compressor);
        return I;
    }

    public static Account getInstance(NETWORK network) {
        return BitcoinAccount.getInstance(network, null, null);
    }

    public static Account getInstance(NETWORK network, BigInteger privateKey, Encryptor encryptor, Compressor compressor) {
        I = new BitcoinAccount(BitcoinAccount.setNetwork(network), privateKey);
        I.setEncryptor(encryptor);
        I.setCompressor(compressor);
        return I;
    }

    public static Account getInstance(NETWORK network, BigInteger privateKey) {
        return BitcoinAccount.getInstance(network, privateKey, null, null);
    }

    public static Account getInstance(NETWORK network, byte[] privateKey, Encryptor encryptor, Compressor compressor) {
        I = new BitcoinAccount(BitcoinAccount.setNetwork(network), privateKey);
        I.setEncryptor(encryptor);
        I.setCompressor(compressor);
        return I;
    }

    public static Account getInstance(NETWORK network, byte[] privateKey) {
        return BitcoinAccount.getInstance(network, privateKey, null, null);
    }

    public static Account getInstance(NETWORK network, ECKey privateKey, Encryptor encryptor, Compressor compressor) {
        I = new BitcoinAccount(BitcoinAccount.setNetwork(network), privateKey);
        I.setEncryptor(encryptor);
        I.setCompressor(compressor);
        return I;
    }

    public static Account getInstance(NETWORK network, ECKey privateKey) {
        return BitcoinAccount.getInstance(network, privateKey, null, null);
    }

    public NetworkParameters getNetworkParameters() {
        return this.networkParameters;
    }

    public ECKey getKey() {
        return this.key;
    }

    public List<UTXO> getUtxoList() {
        return this.utxoList;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public void setNetworkParameters(NetworkParameters networkParameters) {
        this.networkParameters = networkParameters;
    }

    public void setKey(ECKey key) {
        this.key = key;
    }

    public void setUtxoList(List<UTXO> utxoList) {
        this.utxoList = utxoList;
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitcoinAccount)) {
            return false;
        }
        BitcoinAccount other = (BitcoinAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NetworkParameters this$networkParameters = this.getNetworkParameters();
        NetworkParameters other$networkParameters = other.getNetworkParameters();
        if (this$networkParameters == null ? other$networkParameters != null : !this$networkParameters.equals(other$networkParameters)) {
            return false;
        }
        ECKey this$key = this.getKey();
        ECKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        List<UTXO> this$utxoList = this.getUtxoList();
        List<UTXO> other$utxoList = other.getUtxoList();
        if (this$utxoList == null ? other$utxoList != null : !((Object)this$utxoList).equals(other$utxoList)) {
            return false;
        }
        Encryptor this$encryptor = this.getEncryptor();
        Encryptor other$encryptor = other.getEncryptor();
        if (this$encryptor == null ? other$encryptor != null : !this$encryptor.equals(other$encryptor)) {
            return false;
        }
        Compressor this$compressor = this.getCompressor();
        Compressor other$compressor = other.getCompressor();
        return !(this$compressor == null ? other$compressor != null : !this$compressor.equals(other$compressor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BitcoinAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NetworkParameters $networkParameters = this.getNetworkParameters();
        result = result * 59 + ($networkParameters == null ? 43 : $networkParameters.hashCode());
        ECKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        List<UTXO> $utxoList = this.getUtxoList();
        result = result * 59 + ($utxoList == null ? 43 : ((Object)$utxoList).hashCode());
        Encryptor $encryptor = this.getEncryptor();
        result = result * 59 + ($encryptor == null ? 43 : $encryptor.hashCode());
        Compressor $compressor = this.getCompressor();
        result = result * 59 + ($compressor == null ? 43 : $compressor.hashCode());
        return result;
    }

    public String toString() {
        return "BitcoinAccount(networkParameters=" + this.getNetworkParameters() + ", key=" + this.getKey() + ", utxoList=" + this.getUtxoList() + ", encryptor=" + this.getEncryptor() + ", compressor=" + this.getCompressor() + ")";
    }
}

