/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.statistics.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import network.oxalis.statistics.security.OxalisCipher;
import network.oxalis.statistics.security.UnwrapSymmetricKeyException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class OxalisCipherConverter {
    public OxalisCipher createCipherFromWrappedHexKey(String wrappedSymmetricKeyAsHexString, PrivateKey privateKey) {
        byte[] encodedBytes = this.encodedBytesFromHexString(wrappedSymmetricKeyAsHexString);
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(4, privateKey);
            SecretKey secretKey = (SecretKey)cipher.unwrap(encodedBytes, "AES", 3);
            OxalisCipher oxalisCipher = new OxalisCipher(secretKey);
            return oxalisCipher;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnwrapSymmetricKeyException(wrappedSymmetricKeyAsHexString, e);
        }
        catch (NoSuchPaddingException e) {
            throw new UnwrapSymmetricKeyException(wrappedSymmetricKeyAsHexString, e);
        }
        catch (InvalidKeyException e) {
            throw new UnwrapSymmetricKeyException(wrappedSymmetricKeyAsHexString, e);
        }
    }

    public String getWrappedSymmetricKeyAsString(PublicKey publicKey, OxalisCipher oxalisCipher) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(3, publicKey);
            SecretKey secretKey = oxalisCipher.getSecretKey();
            byte[] encodedBytes = cipher.wrap(secretKey);
            return new String(Hex.encodeHex((byte[])encodedBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create cipher with algorithm: RSA", e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("Unable to create cipher with default padding for algorithm RSA", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("The public key is invalid " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("Error during encryption of symmetric key: " + e.getMessage(), e);
        }
    }

    private byte[] encodedBytesFromHexString(String wrappedSymmetricKeyAsHexString) {
        byte[] encodedBytes;
        try {
            encodedBytes = Hex.decodeHex((char[])wrappedSymmetricKeyAsHexString.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Unable to decode hex string " + wrappedSymmetricKeyAsHexString + "; " + e.getMessage(), e);
        }
        return encodedBytes;
    }
}

