/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.statistics.jdbc;

import javax.inject.Inject;
import network.oxalis.persistence.annotation.Repository;
import network.oxalis.persistence.api.JdbcTxManager;
import network.oxalis.statistics.api.StatisticsGranularity;
import network.oxalis.statistics.jdbc.RawStatisticsRepositoryJdbcImpl;

@Repository
public class RawStatisticsRepositoryMsSqlImpl
extends RawStatisticsRepositoryJdbcImpl {
    @Inject
    public RawStatisticsRepositoryMsSqlImpl(JdbcTxManager jdbcTxManager) {
        super(jdbcTxManager);
    }

    @Override
    String getPersistSqlQueryText() {
        return String.format("INSERT INTO %s (ap, tstamp,  direction, sender, receiver, doc_type, profile, channel) values(?,?,?,?,?,?,?,?)", "raw_stats");
    }

    @Override
    String getRawStatisticsSqlQueryText(StatisticsGranularity granularity) {
        String granularityQuery = RawStatisticsRepositoryMsSqlImpl.granularityQuery(granularity);
        String sql = "SELECT\n  ap,\n  'OUT' direction,\n  " + granularityQuery + " period,\n  sender ppid,\n  doc_type,\n  profile,\n  channel,\n  COUNT(*) count\nFROM\n  raw_stats\nWHERE\n  direction = 'OUT'\n  and tstamp between ? and ?\nGROUP BY ap,direction," + granularityQuery + ",sender,doc_type,profile,channel\nunion\nSELECT\n  ap,\n  'IN' direction,\n  " + granularityQuery + " period,\n  receiver ppid,\n  doc_type,\n  profile,\n  channel,\n  COUNT(*) count\nFROM\n  raw_stats\nWHERE\n  direction = 'IN'\n  and tstamp between ? and ?\n\nGROUP BY ap,direction," + granularityQuery + ",receiver,doc_type,profile,channel\norder by period, ap\n;";
        return sql;
    }

    static String granularityQuery(StatisticsGranularity granularity) {
        switch (granularity) {
            case YEAR: {
                return "LEFT(CONVERT(VARCHAR, CONVERT(datetime, tstamp, 121), 121), 4)";
            }
            case MONTH: {
                return "LEFT(CONVERT(VARCHAR, CONVERT(datetime, tstamp, 121), 121), 7)";
            }
            case DAY: {
                return "LEFT(CONVERT(VARCHAR, CONVERT(datetime, tstamp, 121), 121), 10)";
            }
            case HOUR: {
                return "REPLACE(LEFT(CONVERT(VARCHAR, CONVERT(datetime, tstamp, 121), 121), 13), ' ', 'T')";
            }
        }
        throw new IllegalArgumentException(String.format("Unable to convert '%s' into a MsSQL function string", new Object[]{granularity}));
    }
}

