/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.server;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.GuiceModuleLoader;
import network.oxalis.inbound.OxalisGuiceContextListener;
import network.oxalis.server.jetty.JettyConf;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    @Inject
    private Injector injector;
    @Inject
    private Settings<JettyConf> settings;

    public static void main(String ... args) throws Exception {
        ((Main)GuiceModuleLoader.initiate((Module[])new Module[0]).getInstance(Main.class)).run();
    }

    public void run() throws Exception {
        Server server = new Server(this.settings.getInt((Object)JettyConf.PORT));
        HandlerList handlers = new HandlerList();
        if (this.settings.getString((Object)JettyConf.SHUTDOWN_TOKEN) != null) {
            handlers.addHandler((Handler)new ShutdownHandler(this.settings.getString((Object)JettyConf.SHUTDOWN_TOKEN), false, true));
        }
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, this.settings.getString((Object)JettyConf.CONTEXT_PATH));
        handler.addFilter(GuiceFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        handler.addEventListener((EventListener)new OxalisGuiceContextListener(this.injector));
        handler.addServlet(DefaultServlet.class, "/");
        handlers.addHandler((Handler)handler);
        StatisticsHandler statisticsHandler = new StatisticsHandler();
        statisticsHandler.setHandler((Handler)handler);
        handlers.addHandler((Handler)statisticsHandler);
        server.setHandler((Handler)handlers);
        server.setStopTimeout((long)this.settings.getInt((Object)JettyConf.STOP_TIMEOUT));
        server.setStopAtShutdown(true);
        log.info("Starting server");
        server.start();
        server.join();
    }
}

