/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.sniffer.identifier;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.oxalis.sniffer.identifier.CustomizationIdentifier;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;

public class PeppolDocumentTypeId
implements Serializable {
    private final String rootNameSpace;
    private final String localName;
    private final CustomizationIdentifier customizationIdentifier;
    private final String version;
    static Pattern documentIdPattern = Pattern.compile("(.*)::(.*)##(.*)::(.*)");

    public PeppolDocumentTypeId(String rootNameSpace, String localName, CustomizationIdentifier customizationIdentifier, String version) {
        this.rootNameSpace = rootNameSpace;
        this.localName = localName;
        this.customizationIdentifier = customizationIdentifier;
        this.version = version;
    }

    public static PeppolDocumentTypeId valueOf(String documentIdAsText) {
        if (documentIdAsText == null) {
            throw new NullPointerException("Value 'null' is not a valid document type identifier.");
        }
        Matcher matcher = documentIdPattern.matcher(documentIdAsText.trim());
        if (matcher.matches()) {
            String rootNameSpace = matcher.group(1);
            String localName = matcher.group(2);
            String customizationIdAsText = matcher.group(3);
            String version = matcher.group(4);
            CustomizationIdentifier customizationIdentifier = CustomizationIdentifier.valueOf(customizationIdAsText);
            return new PeppolDocumentTypeId(rootNameSpace, localName, customizationIdentifier, version);
        }
        throw new IllegalArgumentException(String.format("Unable to parseOld '%s' into PEPPOL Document Type Identifier", documentIdAsText));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rootNameSpace);
        sb.append("::").append(this.localName);
        sb.append("##").append(this.customizationIdentifier);
        sb.append("::").append(this.version);
        return sb.toString();
    }

    public String getRootNameSpace() {
        return this.rootNameSpace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public CustomizationIdentifier getCustomizationIdentifier() {
        return this.customizationIdentifier;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeppolDocumentTypeId that = (PeppolDocumentTypeId)o;
        return Objects.equals(this.rootNameSpace, that.rootNameSpace) && Objects.equals(this.localName, that.localName) && Objects.equals(this.customizationIdentifier, that.customizationIdentifier) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.rootNameSpace, this.localName, this.customizationIdentifier, this.version);
    }

    public DocumentTypeIdentifier toVefa() {
        return DocumentTypeIdentifier.of((String)this.toString());
    }
}

