/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.sniffer.document.parsers;

import network.oxalis.sniffer.document.PlainUBLParser;
import network.oxalis.sniffer.document.parsers.PEPPOLDocumentParser;
import network.oxalis.sniffer.identifier.ParticipantId;
import network.oxalis.sniffer.identifier.SchemeId;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import org.w3c.dom.Element;

public abstract class AbstractDocumentParser
implements PEPPOLDocumentParser {
    protected PlainUBLParser parser;

    public AbstractDocumentParser(PlainUBLParser parser) {
        this.parser = parser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ParticipantIdentifier participantId(String xPathExpr) {
        ParticipantId ret;
        Element element;
        try {
            element = this.parser.retrieveElementForXpath(xPathExpr);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("No ParticipantId found at '%s'.", xPathExpr));
        }
        String companyId = element.getFirstChild().getNodeValue().trim();
        String schemeIdTextValue = element.getAttribute("schemeID").trim();
        if (ParticipantId.isValidParticipantIdentifierPattern(companyId)) {
            if (schemeIdTextValue.length() == 0) {
                ret = new ParticipantId(companyId);
                return ret.toVefa();
            } else {
                if (!companyId.startsWith(SchemeId.parse(schemeIdTextValue).getCode() + ":")) throw new IllegalStateException(String.format("ParticipantId at '%s' is illegal, schemeId '%s' and icd code prefix of '%s' does not match", xPathExpr, schemeIdTextValue, companyId));
                ret = new ParticipantId(companyId);
            }
            return ret.toVefa();
        } else {
            companyId = String.format("%s:%s", SchemeId.parse(schemeIdTextValue).getCode(), companyId);
            if (!ParticipantId.isValidParticipantIdentifierPattern(companyId)) {
                throw new IllegalStateException(String.format("ParticipantId syntax at '%s' evaluates to '%s' and is invalid", xPathExpr, companyId));
            }
            ret = new ParticipantId(companyId);
        }
        return ret.toVefa();
    }
}

