/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.stream.Collectors;
import network.oxalis.api.lang.OxalisLoadingException;
import network.oxalis.api.settings.Path;
import network.oxalis.api.settings.Settings;

public class ImplLoader {
    public static <T, C> T get(Injector injector, Class<T> cls, Settings<C> settings, C conf) {
        Key key = Key.get(cls, (Annotation)settings.getNamed(conf));
        if (injector.getAllBindings().keySet().contains(key)) {
            return (T)injector.getInstance(key);
        }
        String available = injector.getAllBindings().keySet().stream().filter(k -> k.getTypeLiteral().getRawType().equals(cls)).filter(k -> k.getAnnotation() != null).map(Key::getAnnotation).map(Named.class::cast).map(Named::value).collect(Collectors.joining(", "));
        try {
            Field field = conf.getClass().getField(((Enum)conf).name());
            throw new OxalisLoadingException(String.format("Implementation named '%s' for '%s' (%s) is not found. Available implementations: %s", settings.getString(conf), field.getAnnotation(Path.class).value(), cls.getName(), available));
        }
        catch (NoSuchFieldException e) {
            throw new OxalisLoadingException(e.getMessage(), (Throwable)e);
        }
    }
}

