/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.identifier;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.atomic.AtomicLong;
import network.oxalis.api.identifier.MessageIdGenerator;
import network.oxalis.api.inbound.InboundMetadata;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.util.Type;

@Singleton
@Type(value={"default"})
public class DefaultMessageIdGenerator
implements MessageIdGenerator {
    private String hostname;
    private AtomicLong atomicLong = new AtomicLong();

    @Inject
    public DefaultMessageIdGenerator(@Named(value="hostname") String hostname) {
        this.hostname = hostname;
    }

    public String generate(TransmissionRequest transmissionRequest) {
        return String.format("<%s.%s.%s.Oxalis@%s>", System.currentTimeMillis(), this.atomicLong.incrementAndGet(), transmissionRequest.hashCode(), this.hostname);
    }

    public String generate(InboundMetadata inboundMetadata) {
        return String.format("<%s.%s.%s.Oxalis@%s>", System.currentTimeMillis(), this.atomicLong.incrementAndGet(), inboundMetadata.hashCode(), this.hostname);
    }
}

