/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.filesystem;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.StreamSupport;
import network.oxalis.api.lang.OxalisPluginException;
import network.oxalis.commons.filesystem.FileUtils;

public class ClassLoaderUtils {
    public static ClassLoader initiate(Path path) {
        if (path == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new URLClassLoader(ClassLoaderUtils.findJarFiles(path), Thread.currentThread().getContextClassLoader());
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return new URLClassLoader(new URL[]{FileUtils.toUrl(path)}, Thread.currentThread().getContextClassLoader());
        }
        throw new OxalisPluginException(String.format("Unable to load class loader for '%s'.", path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static URL[] findJarFiles(Path directory) {
        String glob = "*.{jar}";
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, glob);){
            URL[] uRLArray = (URL[])StreamSupport.stream(stream.spliterator(), false).map(FileUtils::toUrl).toArray(URL[]::new);
            return uRLArray;
        }
        catch (IOException e) {
            throw new OxalisPluginException(String.format("Error during list of '%s' files in '%s'.", glob, directory));
        }
    }
}

