/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.inbound;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import network.oxalis.api.inbound.InboundMetadata;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.tag.Tag;
import network.oxalis.api.timestamp.Timestamp;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.Receipt;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.common.model.TransportProtocol;

class As2InboundMetadata
implements InboundMetadata {
    private final TransmissionIdentifier transmissionIdentifier;
    private final Header header;
    private final Date timestamp;
    private final TransportProfile transportProfile;
    private final Digest digest;
    private final Receipt primaryReceipt;
    private final List<Receipt> receipts;
    private final X509Certificate certificate;
    private final Tag tag;

    public As2InboundMetadata(TransmissionIdentifier transmissionIdentifier, Header header, Timestamp timestamp, TransportProfile transportProfile, Digest digest, X509Certificate certificate, byte[] primaryReceipt, Tag tag) {
        this.transmissionIdentifier = transmissionIdentifier;
        this.header = header;
        this.timestamp = timestamp.getDate();
        this.transportProfile = transportProfile;
        this.digest = digest;
        this.certificate = certificate;
        this.primaryReceipt = Receipt.of((String)"message/disposition-notification", (byte[])primaryReceipt);
        this.tag = tag;
        ArrayList<Receipt> receipts = new ArrayList<Receipt>();
        receipts.add(this.primaryReceipt);
        if (timestamp.getReceipt().isPresent()) {
            receipts.add((Receipt)timestamp.getReceipt().get());
        }
        this.receipts = Collections.unmodifiableList(receipts);
    }

    public TransmissionIdentifier getTransmissionIdentifier() {
        return this.transmissionIdentifier;
    }

    public Header getHeader() {
        return this.header;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public TransportProfile getProtocol() {
        return this.transportProfile;
    }

    public TransportProtocol getTransportProtocol() {
        return TransportProtocol.AS2;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public List<Receipt> getReceipts() {
        return this.receipts;
    }

    public Receipt primaryReceipt() {
        return this.primaryReceipt;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        As2InboundMetadata that = (As2InboundMetadata)o;
        return Objects.equals(this.transmissionIdentifier, that.transmissionIdentifier) && Objects.equals(this.header, that.header) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.transportProfile, that.transportProfile) && Objects.equals(this.digest, that.digest) && Objects.equals(this.primaryReceipt, that.primaryReceipt) && Objects.equals(this.receipts, that.receipts) && Objects.equals(this.certificate, that.certificate) && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.transmissionIdentifier, this.header, this.timestamp, this.transportProfile, this.digest, this.primaryReceipt, this.receipts, this.certificate, this.tag);
    }
}

