/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.outbound;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.tag.Tag;
import network.oxalis.api.timestamp.Timestamp;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.Receipt;
import network.oxalis.vefa.peppol.common.model.TransportProtocol;

class As2TransmissionResponse
implements TransmissionResponse,
Serializable {
    private static final long serialVersionUID = 4288900204693153668L;
    private final Tag tag;
    private final Header header;
    private final Endpoint endpoint;
    private final TransmissionIdentifier transmissionIdentifier;
    private final Digest digest;
    private final Receipt receipt;
    private final List<Receipt> receipts;
    private final Date timestamp;

    public As2TransmissionResponse(TransmissionIdentifier transmissionIdentifier, TransmissionRequest transmissionRequest, Digest digest, byte[] nativeEvidenceBytes, Timestamp timestamp, Date date) {
        this.tag = transmissionRequest.getTag();
        this.header = transmissionRequest.getHeader();
        this.endpoint = transmissionRequest.getEndpoint();
        this.transmissionIdentifier = transmissionIdentifier;
        this.digest = digest;
        this.receipt = Receipt.of((String)"message/disposition-notification", (byte[])nativeEvidenceBytes);
        this.timestamp = date;
        ArrayList<Object> receipts = new ArrayList<Object>();
        receipts.add(this.receipt);
        if (timestamp.getReceipt().isPresent()) {
            receipts.add(timestamp.getReceipt().get());
        }
        this.receipts = Collections.unmodifiableList(receipts);
    }

    public Tag getTag() {
        return this.tag;
    }

    public Header getHeader() {
        return this.header;
    }

    public TransmissionIdentifier getTransmissionIdentifier() {
        return this.transmissionIdentifier;
    }

    public List<Receipt> getReceipts() {
        return this.receipts;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Receipt primaryReceipt() {
        return this.receipt;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public TransportProtocol getTransportProtocol() {
        return TransportProtocol.AS2;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }
}

