/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.parser;

import java.security.cert.X509Certificate;
import java.util.Map;
import network.oxalis.commons.certvalidator.Validator;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.Order;
import network.oxalis.commons.certvalidator.api.ValidatorRecipeParser;
import network.oxalis.commons.certvalidator.jaxb.CertificateBucketType;
import network.oxalis.commons.certvalidator.jaxb.CertificateReferenceType;
import network.oxalis.commons.certvalidator.jaxb.CertificateStartsWithType;
import network.oxalis.commons.certvalidator.jaxb.CertificateType;
import network.oxalis.commons.certvalidator.jaxb.ValidatorRecipe;
import network.oxalis.commons.certvalidator.lang.ValidatorParsingException;
import network.oxalis.commons.certvalidator.util.KeyStoreCertificateBucket;
import network.oxalis.commons.certvalidator.util.SimpleCertificateBucket;

@Order(value=200)
public class ValidatorBucketsLoader
implements ValidatorRecipeParser {
    @Override
    public void parse(ValidatorRecipe recipe, Map<String, Object> objectStorage) throws ValidatorParsingException {
        try {
            for (CertificateBucketType certificateBucketType : recipe.getCertificateBucket()) {
                SimpleCertificateBucket certificateBucket = new SimpleCertificateBucket(new X509Certificate[0]);
                for (Object o : certificateBucketType.getCertificateOrCertificateReferenceOrCertificateStartsWith()) {
                    Object c;
                    if (o instanceof CertificateType) {
                        certificateBucket.add(Validator.getCertificate(((CertificateType)o).getValue()));
                        continue;
                    }
                    if (o instanceof CertificateReferenceType) {
                        c = (CertificateReferenceType)o;
                        for (X509Certificate certificate : ValidatorBucketsLoader.getKeyStore(((CertificateReferenceType)c).getKeyStore(), objectStorage).toSimple(((CertificateReferenceType)c).getValue())) {
                            certificateBucket.add(certificate);
                        }
                        continue;
                    }
                    if (!(o instanceof CertificateStartsWithType)) continue;
                    c = (CertificateStartsWithType)o;
                    for (X509Certificate certificate : ValidatorBucketsLoader.getKeyStore(((CertificateStartsWithType)c).getKeyStore(), objectStorage).startsWith(((CertificateStartsWithType)c).getValue())) {
                        certificateBucket.add(certificate);
                    }
                }
                objectStorage.put(String.format("#bucket::%s", certificateBucketType.getName()), certificateBucket);
            }
        }
        catch (CertificateValidationException e) {
            throw new ValidatorParsingException(e.getMessage(), e);
        }
    }

    private static KeyStoreCertificateBucket getKeyStore(String name, Map<String, Object> objectStorage) {
        return (KeyStoreCertificateBucket)objectStorage.get(String.format("#keyStore::%s", name == null ? "default" : name));
    }
}

